<?php

use App\Http\Controllers\ReporteController;
use App\Http\Controllers\ParteBController;
use App\Http\Controllers\ReporteListController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\ReportePdfController;
use App\Http\Controllers\ReporteExportController;
use App\Http\Controllers\Admin\CatalogoController;
use App\Http\Controllers\Admin\UsuarioController;
use App\Http\Controllers\Auth\LoginController;
use Illuminate\Support\Facades\Route;

// Formulario público (sin auth)
Route::get('/', [ReporteController::class, 'create'])->name('reporte.create');
Route::post('/reporte', [ReporteController::class, 'store'])->name('reporte.store');
Route::get('/reporte/{reporte}/confirmacion', [ReporteController::class, 'confirmacion'])->name('reporte.confirmacion');

// Auth
Route::get('/login', [LoginController::class, 'showLoginForm'])->name('login');
Route::post('/login', [LoginController::class, 'login']);
Route::post('/logout', [LoginController::class, 'logout'])->name('logout');

// Rutas protegidas (supervisor + admin)
Route::middleware(['auth'])->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

    Route::get('/reportes', [ReporteListController::class, 'index'])->name('reportes.index');
    Route::get('/reportes/export/excel', [ReporteExportController::class, 'excel'])->name('reportes.export.excel');
    Route::get('/reportes/export/pdf-masivo', [ReportePdfController::class, 'masivo'])->name('reportes.export.pdf-masivo');
    Route::get('/reportes/{reporte}', [ReporteListController::class, 'show'])->name('reportes.show');
    Route::get('/reportes/{reporte}/parte-b', [ParteBController::class, 'edit'])->name('reportes.parte-b.edit');
    Route::put('/reportes/{reporte}/parte-b', [ParteBController::class, 'update'])->name('reportes.parte-b.update');
    Route::get('/reportes/{reporte}/pdf', [ReportePdfController::class, 'show'])->name('reportes.pdf');

    // Admin
    Route::middleware(['role:admin'])->prefix('admin')->name('admin.')->group(function () {
        Route::get('/catalogos', [CatalogoController::class, 'index'])->name('catalogos.index');
        Route::get('/catalogos/{catalogo}', [CatalogoController::class, 'manage'])->name('catalogos.manage');
        Route::post('/catalogos/{catalogo}', [CatalogoController::class, 'store'])->name('catalogos.store');
        Route::put('/catalogos/{catalogo}/{id}', [CatalogoController::class, 'update'])->name('catalogos.update');
        Route::patch('/catalogos/{catalogo}/{id}/toggle', [CatalogoController::class, 'toggle'])->name('catalogos.toggle');
        Route::delete('/catalogos/{catalogo}/{id}', [CatalogoController::class, 'destroy'])->name('catalogos.destroy');

        Route::resource('usuarios', UsuarioController::class);
    });
});
