@extends('layouts.admin')

@section('page-title', 'Detalle del Reporte')

@section('content')
<div class="space-y-6">

    {{-- Header --}}
    <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
        <div class="flex items-center gap-3">
            <a href="{{ route('reportes.index') }}" class="text-gray-400 hover:text-gray-600 transition-colors">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/>
                </svg>
            </a>
            <div>
                <h2 class="text-xl font-bold text-gray-800">Reporte {{ $reporte->codigo }}</h2>
                <p class="text-sm text-gray-500">Creado el {{ $reporte->created_at->format('d/m/Y H:i') }}</p>
            </div>
        </div>
        <div class="flex items-center gap-3">
            @php
                $estadoColors = [
                    'pendiente' => 'bg-yellow-100 text-yellow-800',
                    'en proceso' => 'bg-blue-100 text-blue-800',
                    'completado' => 'bg-green-100 text-green-800',
                    'cerrado' => 'bg-gray-100 text-gray-800',
                    'vencido' => 'bg-red-100 text-red-800',
                ];
                $estadoNombre = strtolower($reporte->estado->nombre ?? '');
                $estadoClass = $estadoColors[$estadoNombre] ?? 'bg-gray-100 text-gray-800';
            @endphp
            <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium {{ $estadoClass }}">
                {{ $reporte->estado->nombre ?? 'Sin estado' }}
            </span>
        </div>
    </div>

    {{-- Botones de accion --}}
    <div class="flex flex-wrap gap-3">
        <a href="{{ route('reportes.pdf', $reporte) }}" target="_blank"
           class="inline-flex items-center px-4 py-2 bg-red-600 text-white text-sm font-medium rounded-lg hover:bg-red-700 transition-colors">
            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
            </svg>
            Exportar PDF
        </a>
        <a href="{{ route('reportes.parte-b.edit', $reporte) }}"
           class="inline-flex items-center px-4 py-2 bg-amber-600 text-white text-sm font-medium rounded-lg hover:bg-amber-700 transition-colors">
            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
            </svg>
            {{ $reporte->accion_correctiva ? 'Editar Parte B' : 'Completar Parte B' }}
        </a>
    </div>

    {{-- Contenido en dos columnas --}}
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">

        {{-- PARTE A --}}
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
            <div class="px-6 py-4 border-b" style="background-color: rgba(59,127,168,0.1); border-color: rgba(59,127,168,0.2);">
                <h3 class="text-lg font-semibold" style="color: #185E83;">Parte A - Reporte Inicial</h3>
            </div>
            <div class="p-6 space-y-4">
                {{-- Campos de informacion --}}
                <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                    <div>
                        <p class="text-xs font-medium text-gray-500 uppercase tracking-wider">Tipo</p>
                        <p class="mt-1 text-sm text-gray-800">{{ $reporte->tipo->nombre ?? 'N/A' }}</p>
                    </div>
                    <div>
                        <p class="text-xs font-medium text-gray-500 uppercase tracking-wider">Lugar</p>
                        <p class="mt-1 text-sm text-gray-800">{{ $reporte->lugar->nombre ?? 'N/A' }}</p>
                    </div>
                    <div>
                        <p class="text-xs font-medium text-gray-500 uppercase tracking-wider">Area</p>
                        <p class="mt-1 text-sm text-gray-800">{{ $reporte->area->nombre ?? 'N/A' }}</p>
                    </div>
                    <div>
                        <p class="text-xs font-medium text-gray-500 uppercase tracking-wider">Turno</p>
                        <p class="mt-1 text-sm text-gray-800">{{ $reporte->turno->nombre ?? 'N/A' }}</p>
                    </div>
                    <div>
                        <p class="text-xs font-medium text-gray-500 uppercase tracking-wider">Fecha</p>
                        <p class="mt-1 text-sm text-gray-800">{{ $reporte->created_at->format('d/m/Y H:i') }}</p>
                    </div>
                    <div>
                        <p class="text-xs font-medium text-gray-500 uppercase tracking-wider">Reportado por</p>
                        <p class="mt-1 text-sm text-gray-800">{{ $reporte->nombre_reportante }}</p>
                    </div>
                </div>

                {{-- Nivel de riesgo --}}
                <div>
                    <p class="text-xs font-medium text-gray-500 uppercase tracking-wider">Nivel de Riesgo</p>
                    @php
                        $riesgoColors = [
                            'bajo' => 'bg-green-100 text-green-800 border-green-200',
                            'medio' => 'bg-yellow-100 text-yellow-800 border-yellow-200',
                            'alto' => 'bg-orange-100 text-orange-800 border-orange-200',
                            'critico' => 'bg-red-100 text-red-800 border-red-200',
                            'crítico' => 'bg-red-100 text-red-800 border-red-200',
                        ];
                        $riesgoNombre = strtolower($reporte->riesgo->nombre ?? '');
                        $riesgoClass = $riesgoColors[$riesgoNombre] ?? 'bg-gray-100 text-gray-800 border-gray-200';
                    @endphp
                    <span class="mt-1 inline-flex items-center px-3 py-1 rounded-full text-sm font-semibold border {{ $riesgoClass }}">
                        {{ $reporte->riesgo->nombre ?? 'N/A' }}
                    </span>
                </div>

                {{-- Consecuencia ambiental --}}
                <div>
                    <p class="text-xs font-medium text-gray-500 uppercase tracking-wider">Consecuencia Ambiental</p>
                    <p class="mt-1 text-sm text-gray-800">
                        {{ $reporte->consecuencia->nombre ?? 'N/A' }}
                    </p>
                </div>

                {{-- Descripcion --}}
                <div>
                    <p class="text-xs font-medium text-gray-500 uppercase tracking-wider">Descripcion</p>
                    <div class="mt-1 text-sm text-gray-800 bg-gray-50 rounded-lg p-4 whitespace-pre-wrap">{{ $reporte->descripcion }}</div>
                </div>

                {{-- Fotos --}}
                @if($reporte->fotos->isNotEmpty())
                    <div>
                        <p class="text-xs font-medium text-gray-500 uppercase tracking-wider mb-2">Fotos</p>
                        <div class="grid grid-cols-2 sm:grid-cols-3 gap-3">
                            @foreach($reporte->fotos as $foto)
                                <a href="{{ Storage::url($foto->path) }}" target="_blank"
                                   class="block aspect-square rounded-lg overflow-hidden border border-gray-200 hover:border-blue-400 hover:shadow-md transition-all">
                                    <img src="{{ Storage::url($foto->path) }}"
                                         alt="Foto {{ $loop->iteration }}"
                                         class="w-full h-full object-cover">
                                </a>
                            @endforeach
                        </div>
                    </div>
                @endif

                {{-- Firma del trabajador --}}
                @if($reporte->firma_trabajador_path)
                    <div>
                        <p class="text-xs font-medium text-gray-500 uppercase tracking-wider mb-2">Firma del Trabajador</p>
                        <div class="inline-block bg-white border border-gray-200 rounded-lg p-2">
                            <img src="{{ Storage::url($reporte->firma_trabajador_path) }}"
                                 alt="Firma del trabajador"
                                 class="max-h-24">
                        </div>
                    </div>
                @endif
            </div>
        </div>

        {{-- PARTE B --}}
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
            <div class="px-6 py-4 bg-amber-50 border-b border-amber-100">
                <h3 class="text-lg font-semibold text-amber-800">Parte B - Accion Correctiva</h3>
            </div>

            @if($reporte->accion_correctiva)
                <div class="p-6 space-y-4">
                    {{-- Accion correctiva --}}
                    <div>
                        <p class="text-xs font-medium text-gray-500 uppercase tracking-wider">Accion Correctiva</p>
                        <div class="mt-1 text-sm text-gray-800 bg-gray-50 rounded-lg p-4 whitespace-pre-wrap">{{ $reporte->accion_correctiva }}</div>
                    </div>

                    {{-- Supervisor asignado --}}
                    <div>
                        <p class="text-xs font-medium text-gray-500 uppercase tracking-wider">Supervisor Asignado</p>
                        <p class="mt-1 text-sm text-gray-800">{{ $reporte->supervisor->nombre_completo ?? 'N/A' }}</p>
                    </div>

                    {{-- Plazo y fecha limite --}}
                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                        <div>
                            <p class="text-xs font-medium text-gray-500 uppercase tracking-wider">Plazo</p>
                            <p class="mt-1 text-sm text-gray-800">{{ $reporte->plazo->nombre ?? 'N/A' }} ({{ $reporte->plazo->horas ?? '?' }} horas)</p>
                        </div>
                        <div>
                            <p class="text-xs font-medium text-gray-500 uppercase tracking-wider">Fecha Limite</p>
                            <p class="mt-1 text-sm text-gray-800">
                                {{ $reporte->fecha_limite ? $reporte->fecha_limite->format('d/m/Y H:i') : 'N/A' }}
                            </p>
                        </div>
                    </div>

                    {{-- Estado --}}
                    <div>
                        <p class="text-xs font-medium text-gray-500 uppercase tracking-wider">Estado</p>
                        <span class="mt-1 inline-flex items-center px-3 py-1 rounded-full text-sm font-medium {{ $estadoClass }}">
                            {{ $reporte->estado->nombre ?? 'Sin estado' }}
                        </span>
                    </div>

                    {{-- Firma supervisor --}}
                    @if($reporte->firma_supervisor_path)
                        <div>
                            <p class="text-xs font-medium text-gray-500 uppercase tracking-wider mb-2">Firma del Supervisor</p>
                            <div class="inline-block bg-white border border-gray-200 rounded-lg p-2">
                                <img src="{{ Storage::url($reporte->firma_supervisor_path) }}"
                                     alt="Firma del supervisor"
                                     class="max-h-24">
                            </div>
                        </div>
                    @endif
                </div>
            @else
                <div class="p-6 text-center">
                    <div class="mx-auto flex items-center justify-center w-16 h-16 rounded-full bg-amber-100 mb-4">
                        <svg class="w-8 h-8 text-amber-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                    </div>
                    <h4 class="text-lg font-semibold text-gray-700 mb-2">Pendiente de revision</h4>
                    <p class="text-sm text-gray-500 mb-4">La Parte B aun no ha sido completada por un supervisor.</p>
                    <a href="{{ route('reportes.parte-b.edit', $reporte) }}"
                       class="inline-flex items-center px-4 py-2 bg-amber-600 text-white text-sm font-medium rounded-lg hover:bg-amber-700 transition-colors">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                        </svg>
                        Completar Parte B
                    </a>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection
