<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Reportes - Exportación Masiva</title>
    <style>
        @page {
            size: A4 portrait;
            margin: 10px 15px;
        }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: Arial, Helvetica, sans-serif;
            font-size: 10px;
            color: #333;
            line-height: 1.3;
        }

        /* Header */
        .header-table {
            width: 100%;
            border-collapse: collapse;
            background: #185E83;
            color: #ffffff;
            margin-bottom: 4px;
        }
        .header-table td {
            padding: 6px 10px;
            vertical-align: middle;
        }
        .header-brand {
            font-size: 16px;
            font-weight: bold;
            letter-spacing: 1px;
        }
        .header-subtitle {
            font-size: 10px;
            color: #b8d8e8;
            margin-top: 2px;
        }
        .header-right { text-align: right; }
        .header-codigo {
            font-size: 13px;
            font-weight: bold;
            color: #ffffff;
            background: #ED6B37;
            padding: 2px 8px;
            display: inline-block;
        }
        .header-fecha {
            font-size: 8px;
            color: #b8d8e8;
            margin-top: 3px;
        }

        .accent-line {
            height: 3px;
            background: #ED6B37;
            margin-bottom: 5px;
        }

        /* Sections */
        .section-title {
            background: #ED6B37;
            color: #ffffff;
            padding: 3px 10px;
            font-size: 10px;
            font-weight: bold;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-bottom: 4px;
            margin-top: 6px;
        }

        /* Data Tables */
        .info-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 4px;
        }
        .info-table td {
            padding: 2px 5px;
            border: 1px solid #ccd6dd;
            vertical-align: top;
            font-size: 9px;
        }
        .info-table .label {
            background: #e8f0f5;
            font-weight: bold;
            width: 22%;
            font-size: 8px;
            color: #185E83;
        }
        .info-table .value {
            font-size: 9px;
            width: 28%;
        }

        /* Description */
        .descripcion {
            padding: 4px 6px;
            background: #f7f9fa;
            border: 1px solid #ccd6dd;
            margin-bottom: 4px;
            font-size: 9px;
            line-height: 1.3;
        }

        /* Badges */
        .badge {
            display: inline-block;
            padding: 1px 6px;
            font-size: 8px;
            font-weight: bold;
            border-radius: 3px;
        }
        .badge-alto { background: #fecaca; color: #991b1b; border: 1px solid #f87171; }
        .badge-medio { background: #fef3c7; color: #92400e; border: 1px solid #fbbf24; }
        .badge-bajo { background: #d1fae5; color: #065f46; border: 1px solid #34d399; }

        /* Photos */
        .fotos-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 4px;
        }
        .fotos-table td {
            padding: 2px;
            text-align: center;
            vertical-align: middle;
        }
        .fotos-table img {
            max-height: 100px;
            max-width: 100%;
            border: 1px solid #ccd6dd;
        }

        /* Signatures */
        .firmas-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 8px;
        }
        .firmas-table td {
            width: 50%;
            text-align: center;
            padding: 4px 10px;
            vertical-align: bottom;
        }
        .firmas-table img {
            max-height: 50px;
            max-width: 180px;
        }
        .firma-line {
            border-top: 1px solid #666;
            padding-top: 2px;
            margin-top: 3px;
            font-size: 8px;
            color: #555;
            display: inline-block;
            min-width: 160px;
        }

        /* Estado badge */
        .estado-badge {
            display: inline-block;
            padding: 1px 6px;
            font-size: 8px;
            font-weight: bold;
            background: #3B7FA8;
            color: #ffffff;
            border-radius: 3px;
        }

        /* Pendiente */
        .pendiente-notice {
            padding: 5px;
            background: #fef3c7;
            border: 1px solid #f59e0b;
            text-align: center;
            font-size: 9px;
            color: #92400e;
            margin-top: 4px;
        }

        /* Footer */
        .footer-bar {
            width: 100%;
            border-collapse: collapse;
            margin-top: 6px;
        }
        .footer-bar td {
            background: #185E83;
            color: #b8d8e8;
            font-size: 7px;
            padding: 2px 8px;
            text-align: center;
        }

        .page-break { page-break-after: always; }
    </style>
</head>
<body>
@foreach($reportes as $index => $reporte)

    {{-- Header --}}
    <table class="header-table">
        <tr>
            <td style="width: 60%;">
                <div class="header-brand">MEDSURSA</div>
                <div class="header-subtitle">Reporta &mdash; Sistema de Reportes de Seguridad</div>
            </td>
            <td class="header-right">
                <div class="header-codigo">{{ $reporte->codigo }}</div>
                <div class="header-fecha">Generado: {{ now()->format('d/m/Y H:i') }}</div>
            </td>
        </tr>
    </table>
    <div class="accent-line"></div>

    {{-- Parte A --}}
    <div class="section-title">Parte A &mdash; Datos del Reporte</div>

    <table class="info-table">
        <tr>
            <td class="label">Tipo</td>
            <td class="value">{{ $reporte->tipo->nombre ?? 'N/A' }}</td>
            <td class="label">Fecha</td>
            <td class="value">{{ $reporte->created_at->format('d/m/Y H:i') }}</td>
        </tr>
        <tr>
            <td class="label">Lugar</td>
            <td class="value">{{ $reporte->lugar->nombre ?? 'N/A' }}</td>
            <td class="label">&Aacute;rea</td>
            <td class="value">{{ $reporte->area->nombre ?? 'N/A' }}</td>
        </tr>
        <tr>
            <td class="label">Turno</td>
            <td class="value">{{ $reporte->turno->nombre ?? 'N/A' }}</td>
            <td class="label">Reportado por</td>
            <td class="value">{{ $reporte->nombre_reportante }}</td>
        </tr>
        <tr>
            <td class="label">Nivel de Riesgo</td>
            <td class="value">
                @php
                    $riesgoNombre = $reporte->riesgo->nombre ?? '';
                    $badgeClass = match(strtolower($riesgoNombre)) {
                        'alto' => 'badge-alto',
                        'medio' => 'badge-medio',
                        'bajo' => 'badge-bajo',
                        default => ''
                    };
                @endphp
                <span class="badge {{ $badgeClass }}">{{ $riesgoNombre ?: 'N/A' }}</span>
            </td>
            <td class="label">Consecuencia Ambiental</td>
            <td class="value">{{ $reporte->consecuencia->nombre ?? 'N/A' }}</td>
        </tr>
    </table>

    <div class="descripcion"><strong>Descripci&oacute;n:</strong> {{ $reporte->descripcion }}</div>

    {{-- Photos --}}
    @if($reporte->fotos->count() > 0)
        <table class="fotos-table">
            <tr>
                @foreach($reporte->fotos as $fIndex => $foto)
                    @php $base64 = \App\Helpers\PdfHelper::imageToBase64($foto->path); @endphp
                    @if($base64)
                        <td style="width: 30%;">
                            <img src="{{ $base64 }}" alt="Foto {{ $foto->orden }}">
                        </td>
                        @if(($fIndex + 1) % 3 == 0 && !$loop->last)
                            </tr><tr>
                        @endif
                    @endif
                @endforeach
            </tr>
        </table>
    @endif

    {{-- Parte B --}}
    <div class="section-title">Parte B &mdash; Acci&oacute;n Correctiva</div>

    @if($reporte->accion_correctiva)
        <table class="info-table">
            <tr>
                <td class="label">Acci&oacute;n Correctiva</td>
                <td class="value" colspan="3">{{ $reporte->accion_correctiva }}</td>
            </tr>
            <tr>
                <td class="label">Supervisor</td>
                <td class="value">{{ $reporte->supervisor->nombre_completo ?? 'N/A' }}</td>
                <td class="label">Plazo</td>
                <td class="value">{{ $reporte->plazo->nombre ?? 'N/A' }}</td>
            </tr>
            <tr>
                <td class="label">Fecha L&iacute;mite</td>
                <td class="value">{{ $reporte->fecha_limite?->format('d/m/Y H:i') ?? 'N/A' }}</td>
                <td class="label">Estado</td>
                <td class="value">
                    <span class="estado-badge">{{ $reporte->estado->nombre ?? 'N/A' }}</span>
                </td>
            </tr>
        </table>
    @else
        <div class="pendiente-notice">
            Pendiente de revisi&oacute;n por supervisor
        </div>
    @endif

    {{-- Signatures --}}
    <table class="firmas-table">
        <tr>
            <td>
                @php $firmaTrabajador = \App\Helpers\PdfHelper::imageToBase64($reporte->firma_trabajador_path); @endphp
                @if($firmaTrabajador)
                    <img src="{{ $firmaTrabajador }}" alt="Firma Trabajador"><br>
                @else
                    <div style="height: 50px;"></div>
                @endif
                <div class="firma-line">Firma del Trabajador</div>
            </td>
            <td>
                @php $firmaSupervisor = \App\Helpers\PdfHelper::imageToBase64($reporte->firma_supervisor_path); @endphp
                @if($firmaSupervisor)
                    <img src="{{ $firmaSupervisor }}" alt="Firma Supervisor"><br>
                @else
                    <div style="height: 50px;"></div>
                @endif
                <div class="firma-line">Firma del Supervisor</div>
            </td>
        </tr>
    </table>

    {{-- Footer --}}
    <table class="footer-bar">
        <tr>
            <td>
                MEDSURSA &bull; Reporte de Incidentes, Actos y Condiciones Subest&aacute;ndar &bull; {{ $reporte->codigo }}
            </td>
        </tr>
    </table>

    @if(!$loop->last)<div class="page-break"></div>@endif
@endforeach
</body>
</html>
