<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Reporte {{ $reporte->codigo }}</title>
    <style>
        @page {
            size: A4 portrait;
            margin: 10px 15px;
        }
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: Arial, Helvetica, sans-serif;
            font-size: 10px;
            color: #333;
            line-height: 1.3;
        }

        /* ---- Header ---- */
        .header-table {
            width: 100%;
            border-collapse: collapse;
            background: #185E83;
            color: #ffffff;
            margin-bottom: 8px;
        }
        .header-table td {
            padding: 8px 12px;
            vertical-align: middle;
        }
        .header-brand {
            font-size: 18px;
            font-weight: bold;
            letter-spacing: 1px;
        }
        .header-subtitle {
            font-size: 11px;
            font-weight: normal;
            color: #b8d8e8;
            margin-top: 2px;
        }
        .header-right {
            text-align: right;
        }
        .header-codigo {
            font-size: 14px;
            font-weight: bold;
            color: #ffffff;
            background: #ED6B37;
            padding: 3px 10px;
            display: inline-block;
            letter-spacing: 0.5px;
        }
        .header-fecha {
            font-size: 9px;
            color: #b8d8e8;
            margin-top: 4px;
        }

        /* ---- Section Titles ---- */
        .section-title {
            background: #ED6B37;
            color: #ffffff;
            padding: 4px 10px;
            font-size: 11px;
            font-weight: bold;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-bottom: 6px;
            margin-top: 10px;
        }
        .section-subtitle {
            font-size: 8px;
            color: #777;
            margin-bottom: 5px;
            padding-left: 10px;
            font-style: italic;
        }

        /* ---- Data Tables ---- */
        .info-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 6px;
        }
        .info-table td {
            padding: 3px 6px;
            border: 1px solid #ccd6dd;
            vertical-align: top;
            font-size: 10px;
        }
        .info-table .label {
            background: #e8f0f5;
            font-weight: bold;
            width: 22%;
            font-size: 9px;
            color: #185E83;
        }
        .info-table .value {
            font-size: 10px;
            width: 28%;
        }

        /* ---- Description ---- */
        .descripcion-label {
            font-weight: bold;
            font-size: 9px;
            color: #185E83;
            margin-bottom: 2px;
            margin-top: 4px;
        }
        .descripcion {
            padding: 5px 8px;
            background: #f7f9fa;
            border: 1px solid #ccd6dd;
            margin-bottom: 6px;
            font-size: 10px;
            line-height: 1.4;
            min-height: 30px;
        }

        /* ---- Badges ---- */
        .badge {
            display: inline-block;
            padding: 1px 8px;
            font-size: 9px;
            font-weight: bold;
            border-radius: 3px;
        }
        .badge-alto {
            background: #fecaca;
            color: #991b1b;
            border: 1px solid #f87171;
        }
        .badge-medio {
            background: #fef3c7;
            color: #92400e;
            border: 1px solid #fbbf24;
        }
        .badge-bajo {
            background: #d1fae5;
            color: #065f46;
            border: 1px solid #34d399;
        }

        /* ---- Photos ---- */
        .fotos-label {
            font-weight: bold;
            font-size: 9px;
            color: #185E83;
            margin-bottom: 3px;
            margin-top: 4px;
        }
        .fotos-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 6px;
        }
        .fotos-table td {
            padding: 2px;
            text-align: center;
            vertical-align: middle;
        }
        .fotos-table img {
            max-height: 120px;
            max-width: 100%;
            border: 1px solid #ccd6dd;
        }

        /* ---- Pendiente Notice ---- */
        .pendiente-notice {
            padding: 8px;
            background: #fef3c7;
            border: 1px solid #f59e0b;
            text-align: center;
            font-size: 10px;
            color: #92400e;
            margin-top: 6px;
        }

        /* ---- Signatures ---- */
        .firmas-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 12px;
        }
        .firmas-table td {
            width: 50%;
            text-align: center;
            padding: 6px 15px;
            vertical-align: bottom;
        }
        .firmas-table img {
            max-height: 60px;
            max-width: 200px;
        }
        .firma-line {
            border-top: 1px solid #666;
            padding-top: 3px;
            margin-top: 4px;
            font-size: 9px;
            color: #555;
            display: inline-block;
            min-width: 180px;
        }

        /* ---- Footer ---- */
        .footer-bar {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        .footer-bar td {
            background: #185E83;
            color: #b8d8e8;
            font-size: 7px;
            padding: 3px 10px;
            text-align: center;
        }

        /* ---- Accent line under header ---- */
        .accent-line {
            height: 3px;
            background: #ED6B37;
            margin-bottom: 6px;
        }

        /* ---- Estado badge ---- */
        .estado-badge {
            display: inline-block;
            padding: 1px 8px;
            font-size: 9px;
            font-weight: bold;
            background: #3B7FA8;
            color: #ffffff;
            border-radius: 3px;
        }
    </style>
</head>
<body>

    {{-- ===== HEADER ===== --}}
    <table class="header-table">
        <tr>
            <td style="width: 60%;">
                <div class="header-brand">MEDSURSA</div>
                <div class="header-subtitle">Reporta &mdash; Sistema de Reportes de Seguridad</div>
            </td>
            <td class="header-right">
                <div class="header-codigo">{{ $reporte->codigo }}</div>
                <div class="header-fecha">Generado: {{ now()->format('d/m/Y H:i') }}</div>
            </td>
        </tr>
    </table>
    <div class="accent-line"></div>

    {{-- ===== PARTE A ===== --}}
    <div class="section-title">Parte A &mdash; Datos del Reporte</div>
    <div class="section-subtitle">Para ser llenado con letra clara y legible por el trabajador.</div>

    <table class="info-table">
        <tr>
            <td class="label">Tipo</td>
            <td class="value">{{ $reporte->tipo->nombre ?? 'N/A' }}</td>
            <td class="label">Fecha</td>
            <td class="value">{{ $reporte->created_at->format('d/m/Y H:i') }}</td>
        </tr>
        <tr>
            <td class="label">Lugar</td>
            <td class="value">{{ $reporte->lugar->nombre ?? 'N/A' }}</td>
            <td class="label">&Aacute;rea</td>
            <td class="value">{{ $reporte->area->nombre ?? 'N/A' }}</td>
        </tr>
        <tr>
            <td class="label">Turno</td>
            <td class="value">{{ $reporte->turno->nombre ?? 'N/A' }}</td>
            <td class="label">Reportado por</td>
            <td class="value">{{ $reporte->nombre_reportante }}</td>
        </tr>
        <tr>
            <td class="label">Nivel de Riesgo</td>
            <td class="value">
                @php
                    $riesgoNombre = $reporte->riesgo->nombre ?? '';
                    $badgeClass = match(strtolower($riesgoNombre)) {
                        'alto' => 'badge-alto',
                        'medio' => 'badge-medio',
                        'bajo' => 'badge-bajo',
                        default => ''
                    };
                @endphp
                <span class="badge {{ $badgeClass }}">{{ $riesgoNombre ?: 'N/A' }}</span>
            </td>
            <td class="label">Consecuencia Ambiental</td>
            <td class="value">{{ $reporte->consecuencia->nombre ?? 'N/A' }}</td>
        </tr>
    </table>

    {{-- Description --}}
    <div class="descripcion-label">Descripci&oacute;n:</div>
    <div class="descripcion">{{ $reporte->descripcion }}</div>

    {{-- Photos --}}
    @if($reporte->fotos->count() > 0)
        <div class="fotos-label">Fotograf&iacute;as:</div>
        <table class="fotos-table">
            <tr>
                @foreach($reporte->fotos as $index => $foto)
                    @php $base64 = \App\Helpers\PdfHelper::imageToBase64($foto->path); @endphp
                    @if($base64)
                        <td style="width: 30%;">
                            <img src="{{ $base64 }}" alt="Foto {{ $foto->orden }}">
                        </td>
                        {{-- Max 3 photos per row --}}
                        @if(($index + 1) % 3 == 0 && !$loop->last)
                            </tr><tr>
                        @endif
                    @endif
                @endforeach
                {{-- Fill remaining cells if needed --}}
                @php
                    $validPhotos = $reporte->fotos->filter(function($f) {
                        return \App\Helpers\PdfHelper::imageToBase64($f->path) !== '';
                    })->count();
                    $remainder = $validPhotos % 3;
                @endphp
                @if($remainder > 0)
                    @for($i = 0; $i < (3 - $remainder); $i++)
                        <td style="width: 30%;"></td>
                    @endfor
                @endif
            </tr>
        </table>
    @endif

    {{-- ===== PARTE B ===== --}}
    <div class="section-title">Parte B &mdash; Acci&oacute;n Correctiva</div>
    <div class="section-subtitle">Para ser llenado de forma clara y legible por el supervisor.</div>

    @if($reporte->accion_correctiva)
        <table class="info-table">
            <tr>
                <td class="label">Acci&oacute;n Correctiva</td>
                <td class="value" colspan="3">{{ $reporte->accion_correctiva }}</td>
            </tr>
            <tr>
                <td class="label">Supervisor</td>
                <td class="value">{{ $reporte->supervisor->nombre_completo ?? 'N/A' }}</td>
                <td class="label">Plazo</td>
                <td class="value">{{ $reporte->plazo->nombre ?? 'N/A' }}</td>
            </tr>
            <tr>
                <td class="label">Fecha L&iacute;mite</td>
                <td class="value">{{ $reporte->fecha_limite?->format('d/m/Y H:i') ?? 'N/A' }}</td>
                <td class="label">Estado</td>
                <td class="value">
                    <span class="estado-badge">{{ $reporte->estado->nombre ?? 'N/A' }}</span>
                </td>
            </tr>
        </table>
    @else
        <div class="pendiente-notice">
            Pendiente de revisi&oacute;n por supervisor
        </div>
    @endif

    {{-- ===== SIGNATURES ===== --}}
    <table class="firmas-table">
        <tr>
            <td>
                @php $firmaTrabajador = \App\Helpers\PdfHelper::imageToBase64($reporte->firma_trabajador_path); @endphp
                @if($firmaTrabajador)
                    <img src="{{ $firmaTrabajador }}" alt="Firma Trabajador"><br>
                @else
                    <div style="height: 60px;"></div>
                @endif
                <div class="firma-line">Firma del Trabajador</div>
            </td>
            <td>
                @php $firmaSupervisor = \App\Helpers\PdfHelper::imageToBase64($reporte->firma_supervisor_path); @endphp
                @if($firmaSupervisor)
                    <img src="{{ $firmaSupervisor }}" alt="Firma Supervisor"><br>
                @else
                    <div style="height: 60px;"></div>
                @endif
                <div class="firma-line">Firma del Supervisor</div>
            </td>
        </tr>
    </table>

    {{-- ===== FOOTER ===== --}}
    <table class="footer-bar">
        <tr>
            <td>
                MEDSURSA &bull; Reporte de Incidentes, Actos y Condiciones Subest&aacute;ndar &bull; {{ $reporte->codigo }} &bull; Generado: {{ now()->format('d/m/Y H:i') }}
            </td>
        </tr>
    </table>

</body>
</html>
