@extends('layouts.admin')

@section('page-title', 'Reportes')

@section('content')
<div class="space-y-6">

    {{-- Header con botones de exportacion --}}
    <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
        <h2 class="text-xl font-bold text-gray-800">Listado de Reportes</h2>
        <div class="flex flex-wrap gap-2">
            <a href="{{ route('reportes.export.excel', request()->query()) }}"
               class="inline-flex items-center px-4 py-2 bg-green-600 text-white text-sm font-medium rounded-lg hover:bg-green-700 transition-colors">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                </svg>
                Exportar Excel
            </a>
            <a href="{{ route('reportes.export.pdf-masivo', request()->query()) }}"
               class="inline-flex items-center px-4 py-2 bg-red-600 text-white text-sm font-medium rounded-lg hover:bg-red-700 transition-colors">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"/>
                </svg>
                PDF Masivo
            </a>
        </div>
    </div>

    {{-- Panel de filtros colapsable --}}
    <div x-data="{ open: {{ collect($filters)->filter()->isNotEmpty() ? 'true' : 'false' }} }" class="bg-white rounded-xl shadow-sm border border-gray-200">
        <button @click="open = !open"
                class="w-full flex items-center justify-between px-6 py-4 text-left focus:outline-none">
            <div class="flex items-center">
                <svg class="w-5 h-5 text-gray-500 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 4a1 1 0 011-1h16a1 1 0 011 1v2.586a1 1 0 01-.293.707l-6.414 6.414a1 1 0 00-.293.707V17l-4 4v-6.586a1 1 0 00-.293-.707L3.293 7.293A1 1 0 013 6.586V4z"/>
                </svg>
                <span class="font-semibold text-gray-700">Filtros</span>
                @if(collect($filters)->filter()->isNotEmpty())
                    <span class="ml-2 inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium text-white" style="background-color: #ED6B37;">
                        Activos
                    </span>
                @endif
            </div>
            <svg class="w-5 h-5 text-gray-400 transition-transform" :class="{ 'rotate-180': open }" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
            </svg>
        </button>

        <div x-show="open" x-collapse x-cloak>
            <form method="GET" action="{{ route('reportes.index') }}" class="px-6 pb-6">
                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-4">
                    {{-- Fecha desde --}}
                    <div>
                        <label for="fecha_desde" class="block text-sm font-medium text-gray-700 mb-1">Fecha desde</label>
                        <input type="date" name="fecha_desde" id="fecha_desde" value="{{ $filters['fecha_desde'] ?? '' }}"
                               class="w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 text-sm">
                    </div>

                    {{-- Fecha hasta --}}
                    <div>
                        <label for="fecha_hasta" class="block text-sm font-medium text-gray-700 mb-1">Fecha hasta</label>
                        <input type="date" name="fecha_hasta" id="fecha_hasta" value="{{ $filters['fecha_hasta'] ?? '' }}"
                               class="w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 text-sm">
                    </div>

                    {{-- Tipo --}}
                    <div>
                        <label for="tipo_id" class="block text-sm font-medium text-gray-700 mb-1">Tipo</label>
                        <select name="tipo_id" id="tipo_id"
                                class="w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 text-sm">
                            <option value="">Todos</option>
                            @foreach($tipos as $tipo)
                                <option value="{{ $tipo->id }}" {{ ($filters['tipo_id'] ?? '') == $tipo->id ? 'selected' : '' }}>
                                    {{ $tipo->nombre }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    {{-- Lugar --}}
                    <div>
                        <label for="lugar_id" class="block text-sm font-medium text-gray-700 mb-1">Lugar</label>
                        <select name="lugar_id" id="lugar_id"
                                class="w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 text-sm">
                            <option value="">Todos</option>
                            @foreach($lugares as $lugar)
                                <option value="{{ $lugar->id }}" {{ ($filters['lugar_id'] ?? '') == $lugar->id ? 'selected' : '' }}>
                                    {{ $lugar->nombre }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    {{-- Area --}}
                    <div>
                        <label for="area_id" class="block text-sm font-medium text-gray-700 mb-1">Area</label>
                        <select name="area_id" id="area_id"
                                class="w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 text-sm">
                            <option value="">Todas</option>
                            @foreach($areas as $area)
                                <option value="{{ $area->id }}" {{ ($filters['area_id'] ?? '') == $area->id ? 'selected' : '' }}>
                                    {{ $area->nombre }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    {{-- Riesgo --}}
                    <div>
                        <label for="riesgo_id" class="block text-sm font-medium text-gray-700 mb-1">Nivel de Riesgo</label>
                        <select name="riesgo_id" id="riesgo_id"
                                class="w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 text-sm">
                            <option value="">Todos</option>
                            @foreach($riesgos as $riesgo)
                                <option value="{{ $riesgo->id }}" {{ ($filters['riesgo_id'] ?? '') == $riesgo->id ? 'selected' : '' }}>
                                    {{ $riesgo->nombre }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    {{-- Estado --}}
                    <div>
                        <label for="estado_id" class="block text-sm font-medium text-gray-700 mb-1">Estado</label>
                        <select name="estado_id" id="estado_id"
                                class="w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 text-sm">
                            <option value="">Todos</option>
                            @foreach($estados as $estado)
                                <option value="{{ $estado->id }}" {{ ($filters['estado_id'] ?? '') == $estado->id ? 'selected' : '' }}>
                                    {{ $estado->nombre }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    {{-- Supervisor --}}
                    <div>
                        <label for="supervisor_id" class="block text-sm font-medium text-gray-700 mb-1">Supervisor</label>
                        <select name="supervisor_id" id="supervisor_id"
                                class="w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 text-sm">
                            <option value="">Todos</option>
                            @foreach($supervisores as $supervisor)
                                <option value="{{ $supervisor->id }}" {{ ($filters['supervisor_id'] ?? '') == $supervisor->id ? 'selected' : '' }}>
                                    {{ $supervisor->nombre_completo }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    {{-- Buscar --}}
                    <div class="sm:col-span-2 lg:col-span-3 xl:col-span-4">
                        <label for="buscar" class="block text-sm font-medium text-gray-700 mb-1">Buscar</label>
                        <input type="text" name="buscar" id="buscar" value="{{ $filters['buscar'] ?? '' }}"
                               placeholder="Buscar por codigo, descripcion o nombre..."
                               class="w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 text-sm">
                    </div>
                </div>

                <div class="flex items-center gap-3 mt-4">
                    <button type="submit"
                            class="inline-flex items-center px-4 py-2 text-white text-sm font-medium rounded-lg transition-colors"
                            style="background-color: #ED6B37;"
                            onmouseover="this.style.backgroundColor='#D4572B'"
                            onmouseout="this.style.backgroundColor='#ED6B37'">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                        </svg>
                        Filtrar
                    </button>
                    <a href="{{ route('reportes.index') }}"
                       class="inline-flex items-center px-4 py-2 bg-gray-200 text-gray-700 text-sm font-medium rounded-lg hover:bg-gray-300 transition-colors">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                        </svg>
                        Limpiar
                    </a>
                </div>
            </form>
        </div>
    </div>

    {{-- Tabla de resultados (desktop) --}}
    <div class="hidden md:block bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-semibold text-gray-500 uppercase tracking-wider">Codigo</th>
                        <th class="px-6 py-3 text-left text-xs font-semibold text-gray-500 uppercase tracking-wider">Fecha</th>
                        <th class="px-6 py-3 text-left text-xs font-semibold text-gray-500 uppercase tracking-wider">Tipo</th>
                        <th class="px-6 py-3 text-left text-xs font-semibold text-gray-500 uppercase tracking-wider">Lugar</th>
                        <th class="px-6 py-3 text-left text-xs font-semibold text-gray-500 uppercase tracking-wider">Riesgo</th>
                        <th class="px-6 py-3 text-left text-xs font-semibold text-gray-500 uppercase tracking-wider">Estado</th>
                        <th class="px-6 py-3 text-right text-xs font-semibold text-gray-500 uppercase tracking-wider">Acciones</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($reportes as $reporte)
                        <tr class="hover:bg-gray-50 transition-colors">
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="text-sm font-mono font-semibold text-blue-600">{{ $reporte->codigo }}</span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-600">
                                {{ $reporte->created_at->format('d/m/Y H:i') }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">
                                {{ $reporte->tipo->nombre ?? 'N/A' }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">
                                {{ $reporte->lugar->nombre ?? 'N/A' }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                @php
                                    $riesgoColors = [
                                        'bajo' => 'bg-green-100 text-green-800',
                                        'medio' => 'bg-yellow-100 text-yellow-800',
                                        'alto' => 'bg-orange-100 text-orange-800',
                                        'critico' => 'bg-red-100 text-red-800',
                                        'crítico' => 'bg-red-100 text-red-800',
                                    ];
                                    $riesgoNombre = strtolower($reporte->riesgo->nombre ?? '');
                                    $riesgoClass = $riesgoColors[$riesgoNombre] ?? 'bg-gray-100 text-gray-800';
                                @endphp
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $riesgoClass }}">
                                    {{ $reporte->riesgo->nombre ?? 'N/A' }}
                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                @php
                                    $estadoColors = [
                                        'pendiente' => 'bg-yellow-100 text-yellow-800',
                                        'en proceso' => 'bg-blue-100 text-blue-800',
                                        'completado' => 'bg-green-100 text-green-800',
                                        'cerrado' => 'bg-gray-100 text-gray-800',
                                        'vencido' => 'bg-red-100 text-red-800',
                                    ];
                                    $estadoNombre = strtolower($reporte->estado->nombre ?? '');
                                    $estadoClass = $estadoColors[$estadoNombre] ?? 'bg-gray-100 text-gray-800';
                                @endphp
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $estadoClass }}">
                                    {{ $reporte->estado->nombre ?? 'N/A' }}
                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-right">
                                <div class="flex items-center justify-end gap-2">
                                    <a href="{{ route('reportes.show', $reporte) }}"
                                       class="inline-flex items-center px-3 py-1.5 text-xs font-medium text-blue-700 bg-blue-50 rounded-lg hover:bg-blue-100 transition-colors"
                                       title="Ver detalle">
                                        Ver
                                    </a>
                                    <a href="{{ route('reportes.parte-b.edit', $reporte) }}"
                                       class="inline-flex items-center px-3 py-1.5 text-xs font-medium text-amber-700 bg-amber-50 rounded-lg hover:bg-amber-100 transition-colors"
                                       title="Completar Parte B">
                                        Parte B
                                    </a>
                                    <a href="{{ route('reportes.pdf', $reporte) }}"
                                       class="inline-flex items-center px-3 py-1.5 text-xs font-medium text-red-700 bg-red-50 rounded-lg hover:bg-red-100 transition-colors"
                                       title="Descargar PDF" target="_blank">
                                        PDF
                                    </a>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="px-6 py-12 text-center">
                                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                                </svg>
                                <p class="mt-2 text-sm text-gray-500">No se encontraron reportes.</p>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    {{-- Cards (mobile) --}}
    <div class="md:hidden space-y-4">
        @forelse($reportes as $reporte)
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-4">
                <div class="flex items-center justify-between mb-3">
                    <span class="text-sm font-mono font-semibold text-blue-600">{{ $reporte->codigo }}</span>
                    @php
                        $riesgoNombre = strtolower($reporte->riesgo->nombre ?? '');
                        $riesgoClass = $riesgoColors[$riesgoNombre] ?? 'bg-gray-100 text-gray-800';
                    @endphp
                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $riesgoClass }}">
                        {{ $reporte->riesgo->nombre ?? 'N/A' }}
                    </span>
                </div>

                <div class="space-y-2 text-sm text-gray-600 mb-3">
                    <div class="flex justify-between">
                        <span class="text-gray-500">Fecha:</span>
                        <span>{{ $reporte->created_at->format('d/m/Y H:i') }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-500">Tipo:</span>
                        <span>{{ $reporte->tipo->nombre ?? 'N/A' }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-500">Lugar:</span>
                        <span>{{ $reporte->lugar->nombre ?? 'N/A' }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-500">Estado:</span>
                        @php
                            $estadoNombre = strtolower($reporte->estado->nombre ?? '');
                            $estadoClass = $estadoColors[$estadoNombre] ?? 'bg-gray-100 text-gray-800';
                        @endphp
                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $estadoClass }}">
                            {{ $reporte->estado->nombre ?? 'N/A' }}
                        </span>
                    </div>
                </div>

                <div class="flex items-center gap-2 pt-3 border-t border-gray-100">
                    <a href="{{ route('reportes.show', $reporte) }}"
                       class="flex-1 text-center px-3 py-2 text-xs font-medium text-blue-700 bg-blue-50 rounded-lg hover:bg-blue-100 transition-colors">
                        Ver
                    </a>
                    <a href="{{ route('reportes.parte-b.edit', $reporte) }}"
                       class="flex-1 text-center px-3 py-2 text-xs font-medium text-amber-700 bg-amber-50 rounded-lg hover:bg-amber-100 transition-colors">
                        Parte B
                    </a>
                    <a href="{{ route('reportes.pdf', $reporte) }}"
                       class="flex-1 text-center px-3 py-2 text-xs font-medium text-red-700 bg-red-50 rounded-lg hover:bg-red-100 transition-colors"
                       target="_blank">
                        PDF
                    </a>
                </div>
            </div>
        @empty
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-8 text-center">
                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                </svg>
                <p class="mt-2 text-sm text-gray-500">No se encontraron reportes.</p>
            </div>
        @endforelse
    </div>

    {{-- Paginacion --}}
    @if($reportes->hasPages())
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 px-6 py-4">
            {{ $reportes->links() }}
        </div>
    @endif
</div>
@endsection
