@extends('layouts.guest')

@section('content')
<div class="flex items-center justify-center min-h-[60vh]">
    <div class="bg-white rounded-xl shadow-lg p-8 sm:p-12 max-w-md w-full text-center">
        {{-- Icono de check verde --}}
        <div class="mx-auto flex items-center justify-center w-20 h-20 rounded-full bg-green-100 mb-6">
            <svg class="w-12 h-12 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M5 13l4 4L19 7"/>
            </svg>
        </div>

        {{-- Mensaje de exito --}}
        <h1 class="text-2xl font-bold text-gray-800 mb-2">Reporte enviado correctamente</h1>
        <p class="text-gray-500 mb-6">Tu reporte ha sido registrado exitosamente en el sistema.</p>

        {{-- Codigo del reporte --}}
        <div class="bg-gray-50 border border-gray-200 rounded-lg p-4 mb-8">
            <p class="text-sm text-gray-500 mb-1">Codigo de seguimiento</p>
            <p class="text-2xl font-mono font-bold" style="color: #ED6B37">{{ $reporte->codigo }}</p>
        </div>

        {{-- Boton para crear otro reporte --}}
        <a href="{{ route('reporte.create') }}"
           class="inline-flex items-center justify-center w-full px-6 py-3 text-white font-semibold rounded-lg transition-colors focus:outline-none focus:ring-2 focus:ring-offset-2"
           style="background-color: #ED6B37; --ring-color: #ED6B37"
           onmouseover="this.style.backgroundColor='#D4572B'"
           onmouseout="this.style.backgroundColor='#ED6B37'">
            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/>
            </svg>
            Crear otro reporte
        </a>
    </div>
</div>
@endsection
