<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>MEDSURSA - Reporta</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        brand: {
                            orange: '#ED6B37',
                            'orange-light': '#F27B36',
                            blue: '#3B7FA8',
                            'blue-dark': '#185E83',
                            yellow: '#FBD136',
                            cyan: '#239CD4',
                            cream: '#F5CAA7',
                        },
                        neutral: {
                            dark: '#3E3A38',
                            medium: '#71615B',
                            white: '#FDFDFD',
                        }
                    }
                }
            }
        }
    </script>
    <style>[x-cloak] { display: none !important; }</style>
</head>
<body class="bg-neutral-white min-h-screen flex flex-col" style="background-color: #FDFDFD;">

    {{-- Header MEDSURSA --}}
    <header class="shadow-sm" style="background-color: #185E83;">
        <div class="max-w-4xl mx-auto px-4 py-3 flex items-center justify-between">
            <a href="/" class="flex items-center space-x-3">
                <div class="w-9 h-9 rounded-lg flex items-center justify-center" style="background-color: #ED6B37;">
                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                              d="M12 9v2m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                </div>
                <div>
                    <span class="text-lg font-bold text-white tracking-wide">MEDSURSA</span>
                    <span class="text-xs text-blue-200 block -mt-1">Reporta</span>
                </div>
            </a>
            <a href="/login" class="text-xs font-medium px-3 py-1.5 rounded-lg transition"
               style="color: #FDFDFD; background-color: rgba(255,255,255,0.15);"
               onmouseover="this.style.backgroundColor='rgba(255,255,255,0.25)'"
               onmouseout="this.style.backgroundColor='rgba(255,255,255,0.15)'">
                Panel Admin
            </a>
        </div>
    </header>

    {{-- Content --}}
    <main class="flex-1 w-full max-w-4xl mx-auto px-4 py-6 sm:py-8">
        @yield('content')
    </main>

    {{-- Footer --}}
    <footer class="border-t mt-auto" style="border-color: #F5CAA7; background-color: #FDFDFD;">
        <div class="max-w-4xl mx-auto px-4 py-4 text-center text-sm" style="color: #71615B;">
            &copy; {{ date('Y') }} <strong>MEDSURSA</strong> &mdash; Sistema de Reportes de Incidentes
        </div>
    </footer>

</body>
</html>
