<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>MEDSURSA - Reporta</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        brand: {
                            orange: '#ED6B37',
                            'orange-light': '#F27B36',
                            blue: '#3B7FA8',
                            'blue-dark': '#185E83',
                            yellow: '#FBD136',
                            cyan: '#239CD4',
                            cream: '#F5CAA7',
                        },
                        neutral: {
                            dark: '#3E3A38',
                            medium: '#71615B',
                            white: '#FDFDFD',
                        }
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-gray-100 min-h-screen" x-data="{ sidebarOpen: false }">

    {{-- Mobile overlay --}}
    <div x-show="sidebarOpen"
         x-transition:enter="transition-opacity ease-linear duration-300"
         x-transition:enter-start="opacity-0"
         x-transition:enter-end="opacity-100"
         x-transition:leave="transition-opacity ease-linear duration-300"
         x-transition:leave-start="opacity-100"
         x-transition:leave-end="opacity-0"
         class="fixed inset-0 z-40 bg-gray-600 bg-opacity-75 lg:hidden"
         @click="sidebarOpen = false"
         x-cloak>
    </div>

    {{-- Sidebar --}}
    <aside class="fixed inset-y-0 left-0 z-50 w-64 transform transition-transform duration-300 ease-in-out lg:translate-x-0"
           style="background-color: #185E83;"
           :class="sidebarOpen ? 'translate-x-0' : '-translate-x-full'"
           @click.away="sidebarOpen = false">

        {{-- Sidebar header / branding --}}
        <div class="flex items-center justify-between h-16 px-4" style="background-color: #124B6A;">
            <a href="{{ route('dashboard') }}" class="flex items-center space-x-2">
                <div class="w-8 h-8 rounded-lg flex items-center justify-center" style="background-color: rgba(255,255,255,0.2);">
                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                              d="M12 9v2m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                </div>
                <div class="flex flex-col leading-tight">
                    <span class="text-lg font-bold text-white">MEDSURSA</span>
                    <span class="text-xs text-gray-300 -mt-0.5">Reporta</span>
                </div>
            </a>
            <button @click="sidebarOpen = false" class="lg:hidden text-gray-300 hover:text-white">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                </svg>
            </button>
        </div>

        {{-- User info --}}
        <div class="px-4 py-4" style="border-bottom: 1px solid rgba(255,255,255,0.1);">
            <div class="flex items-center space-x-3">
                <div class="w-10 h-10 rounded-full flex items-center justify-center text-white font-semibold text-sm" style="background-color: #ED6B37;">
                    {{ strtoupper(substr(auth()->user()->nombre_completo ?? 'U', 0, 1)) }}
                </div>
                <div class="flex-1 min-w-0">
                    <p class="text-sm font-medium text-white truncate">
                        {{ auth()->user()->nombre_completo ?? 'Usuario' }}
                    </p>
                    <p class="text-xs truncate capitalize" style="color: rgba(255,255,255,0.6);">
                        {{ auth()->user()->rol ?? 'usuario' }}
                    </p>
                </div>
            </div>
        </div>

        {{-- Navigation --}}
        <nav class="flex-1 px-3 py-4 space-y-1">
            {{-- Dashboard --}}
            <a href="{{ route('dashboard') }}"
               class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-colors"
               @if(request()->routeIs('dashboard'))
                   style="background-color: rgba(237,107,55,0.15); color: #FFFFFF; border-left: 3px solid #ED6B37;"
               @else
                   style="color: rgba(255,255,255,0.7);"
                   onmouseover="this.style.backgroundColor='rgba(255,255,255,0.1)'; this.style.color='#FFFFFF';"
                   onmouseout="this.style.backgroundColor='transparent'; this.style.color='rgba(255,255,255,0.7)';"
               @endif
            >
                <svg class="mr-3 w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                          d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-4 0a1 1 0 01-1-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 01-1 1h-2z"/>
                </svg>
                Dashboard
            </a>

            {{-- Reportes --}}
            <a href="{{ route('reportes.index') }}"
               class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-colors"
               @if(request()->routeIs('reportes.*'))
                   style="background-color: rgba(237,107,55,0.15); color: #FFFFFF; border-left: 3px solid #ED6B37;"
               @else
                   style="color: rgba(255,255,255,0.7);"
                   onmouseover="this.style.backgroundColor='rgba(255,255,255,0.1)'; this.style.color='#FFFFFF';"
                   onmouseout="this.style.backgroundColor='transparent'; this.style.color='rgba(255,255,255,0.7)';"
               @endif
            >
                <svg class="mr-3 w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                          d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                </svg>
                Reportes
            </a>

            {{-- Admin-only links --}}
            @if(auth()->user() && auth()->user()->rol === 'admin')
                <div class="pt-4">
                    <p class="px-3 text-xs font-semibold uppercase tracking-wider" style="color: rgba(255,255,255,0.4);">
                        Administracion
                    </p>
                </div>

                {{-- Catalogos --}}
                <a href="{{ route('admin.catalogos.index') }}"
                   class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-colors"
                   @if(request()->routeIs('admin.catalogos.*'))
                       style="background-color: rgba(237,107,55,0.15); color: #FFFFFF; border-left: 3px solid #ED6B37;"
                   @else
                       style="color: rgba(255,255,255,0.7);"
                       onmouseover="this.style.backgroundColor='rgba(255,255,255,0.1)'; this.style.color='#FFFFFF';"
                       onmouseout="this.style.backgroundColor='transparent'; this.style.color='rgba(255,255,255,0.7)';"
                   @endif
                >
                    <svg class="mr-3 w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                              d="M4 6h16M4 10h16M4 14h16M4 18h16"/>
                    </svg>
                    Catalogos
                </a>

                {{-- Usuarios --}}
                <a href="{{ route('admin.usuarios.index') }}"
                   class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-colors"
                   @if(request()->routeIs('admin.usuarios.*'))
                       style="background-color: rgba(237,107,55,0.15); color: #FFFFFF; border-left: 3px solid #ED6B37;"
                   @else
                       style="color: rgba(255,255,255,0.7);"
                       onmouseover="this.style.backgroundColor='rgba(255,255,255,0.1)'; this.style.color='#FFFFFF';"
                       onmouseout="this.style.backgroundColor='transparent'; this.style.color='rgba(255,255,255,0.7)';"
                   @endif
                >
                    <svg class="mr-3 w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                              d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m9 5.197V21"/>
                    </svg>
                    Usuarios
                </a>
            @endif
        </nav>

        {{-- Logout --}}
        <div class="px-3 py-4" style="border-top: 1px solid rgba(255,255,255,0.1);">
            <form method="POST" action="{{ route('logout') }}">
                @csrf
                <button type="submit"
                        class="w-full group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-colors"
                        style="color: rgba(255,255,255,0.7);"
                        onmouseover="this.style.backgroundColor='rgba(255,255,255,0.1)'; this.style.color='#FFFFFF';"
                        onmouseout="this.style.backgroundColor='transparent'; this.style.color='rgba(255,255,255,0.7)';">
                    <svg class="mr-3 w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                              d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"/>
                    </svg>
                    Cerrar Sesion
                </button>
            </form>
        </div>
    </aside>

    {{-- Main content area --}}
    <div class="lg:pl-64 min-h-screen flex flex-col">

        {{-- Top bar (mobile) --}}
        <header class="sticky top-0 z-30 bg-white shadow-sm border-b border-gray-200 lg:hidden">
            <div class="flex items-center justify-between h-16 px-4">
                <button @click="sidebarOpen = true"
                        class="text-gray-500 hover:text-gray-700 focus:outline-none rounded-md p-1"
                        style="focus-ring-color: #3B7FA8;">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"/>
                    </svg>
                </button>
                <div class="flex flex-col items-center leading-tight">
                    <span class="text-lg font-bold text-gray-800">MEDSURSA</span>
                    <span class="text-xs text-gray-500 -mt-0.5">Reporta</span>
                </div>
                <div class="w-8 h-8 rounded-full flex items-center justify-center text-white font-semibold text-xs" style="background-color: #ED6B37;">
                    {{ strtoupper(substr(auth()->user()->nombre_completo ?? 'U', 0, 1)) }}
                </div>
            </div>
        </header>

        {{-- Desktop top bar --}}
        <header class="hidden lg:block bg-white shadow-sm border-b border-gray-200">
            <div class="flex items-center justify-between h-16 px-6">
                <h1 class="text-lg font-semibold text-gray-800">
                    @yield('page-title', 'Dashboard')
                </h1>
                <div class="flex items-center space-x-3">
                    <span class="text-sm text-gray-600">{{ auth()->user()->nombre_completo ?? 'Usuario' }}</span>
                    <div class="w-8 h-8 rounded-full flex items-center justify-center text-white font-semibold text-xs" style="background-color: #ED6B37;">
                        {{ strtoupper(substr(auth()->user()->nombre_completo ?? 'U', 0, 1)) }}
                    </div>
                </div>
            </div>
        </header>

        {{-- Page content --}}
        <main class="flex-1 p-4 sm:p-6">
            {{-- Flash messages --}}
            @if(session('success'))
                <div x-data="{ show: true }" x-show="show" x-init="setTimeout(() => show = false, 5000)"
                     x-transition:leave="transition ease-in duration-300"
                     x-transition:leave-start="opacity-100"
                     x-transition:leave-end="opacity-0"
                     class="mb-4 p-4 bg-green-50 border border-green-200 text-green-700 rounded-lg flex items-center justify-between">
                    <div class="flex items-center">
                        <svg class="w-5 h-5 mr-2 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                        </svg>
                        <span class="text-sm">{{ session('success') }}</span>
                    </div>
                    <button @click="show = false" class="text-green-500 hover:text-green-700">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                        </svg>
                    </button>
                </div>
            @endif

            @if(session('error'))
                <div x-data="{ show: true }" x-show="show"
                     class="mb-4 p-4 bg-red-50 border border-red-200 text-red-700 rounded-lg flex items-center justify-between">
                    <div class="flex items-center">
                        <svg class="w-5 h-5 mr-2 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                        <span class="text-sm">{{ session('error') }}</span>
                    </div>
                    <button @click="show = false" class="text-red-500 hover:text-red-700">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                        </svg>
                    </button>
                </div>
            @endif

            @yield('content')
        </main>

        {{-- Footer --}}
        <footer class="bg-white border-t border-gray-200 mt-auto">
            <div class="px-6 py-3 text-center text-xs text-gray-400">
                &copy; {{ date('Y') }} MEDSURSA &mdash; Sistema de Reportes de Incidentes
            </div>
        </footer>
    </div>

    {{-- Alpine.js x-cloak style + focus ring override --}}
    <style>
        [x-cloak] { display: none !important; }
        *:focus-visible {
            outline-color: #3B7FA8 !important;
        }
        button:focus, a:focus {
            outline-color: #3B7FA8;
        }
    </style>

</body>
</html>
