@extends('layouts.admin')

@section('page-title', 'Dashboard')

@section('content')
<div class="space-y-6">

    {{-- KPI Cards --}}
    <div class="grid grid-cols-2 lg:grid-cols-4 gap-4">
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-5">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-500">Total Reportes</p>
                    <p class="text-2xl font-bold text-gray-800 mt-1">{{ $totalReportes }}</p>
                </div>
                <div class="w-10 h-10 rounded-lg flex items-center justify-center" style="background-color: rgba(59,127,168,0.15);">
                    <svg class="w-5 h-5" style="color: #3B7FA8;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                    </svg>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-5">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-500">Este Mes</p>
                    <p class="text-2xl font-bold text-blue-600 mt-1">{{ $reportesMes }}</p>
                </div>
                <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center">
                    <svg class="w-5 h-5 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                    </svg>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-5">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-500">Vencidos</p>
                    <p class="text-2xl font-bold text-red-600 mt-1">{{ $vencidos }}</p>
                </div>
                <div class="w-10 h-10 bg-red-100 rounded-lg flex items-center justify-center">
                    <svg class="w-5 h-5 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-5">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-500">A Tiempo</p>
                    <p class="text-2xl font-bold text-green-600 mt-1">{{ $aTiempo }}</p>
                </div>
                <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center">
                    <svg class="w-5 h-5 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                    </svg>
                </div>
            </div>
        </div>
    </div>

    {{-- Charts Grid --}}
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        {{-- Distribución por Tipo --}}
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-5">
            <h3 class="text-base font-semibold text-gray-800 mb-4">Distribución por Tipo</h3>
            <canvas id="chartTipo" height="250"></canvas>
        </div>

        {{-- Distribución por Riesgo --}}
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-5">
            <h3 class="text-base font-semibold text-gray-800 mb-4">Distribución por Riesgo</h3>
            <canvas id="chartRiesgo" height="250"></canvas>
        </div>

        {{-- Distribución por Área --}}
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-5">
            <h3 class="text-base font-semibold text-gray-800 mb-4">Distribución por Área</h3>
            <canvas id="chartArea" height="250"></canvas>
        </div>

        {{-- Tendencia Mensual --}}
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-5">
            <h3 class="text-base font-semibold text-gray-800 mb-4">Tendencia Mensual</h3>
            <canvas id="chartTendencia" height="250"></canvas>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    const colors = ['#ED6B37','#3B7FA8','#185E83','#FBD136','#239CD4','#F27B36','#71615B','#3E3A38'];

    // Por Tipo
    new Chart(document.getElementById('chartTipo'), {
        type: 'bar',
        data: {
            labels: {!! json_encode($porTipo->map(fn($r) => $r->tipo->nombre ?? 'N/A')) !!},
            datasets: [{
                label: 'Reportes',
                data: {!! json_encode($porTipo->pluck('total')) !!},
                backgroundColor: colors.slice(0, {{ $porTipo->count() }}),
                borderRadius: 6
            }]
        },
        options: { responsive: true, plugins: { legend: { display: false } }, scales: { y: { beginAtZero: true, ticks: { stepSize: 1 } } } }
    });

    // Por Riesgo
    new Chart(document.getElementById('chartRiesgo'), {
        type: 'doughnut',
        data: {
            labels: {!! json_encode($porRiesgo->map(fn($r) => $r->riesgo->nombre ?? 'N/A')) !!},
            datasets: [{
                data: {!! json_encode($porRiesgo->pluck('total')) !!},
                backgroundColor: ['#ef4444','#f59e0b','#10b981','#3B7FA8','#185E83']
            }]
        },
        options: { responsive: true, plugins: { legend: { position: 'bottom' } } }
    });

    // Por Área
    new Chart(document.getElementById('chartArea'), {
        type: 'bar',
        data: {
            labels: {!! json_encode($porArea->map(fn($r) => $r->area->nombre ?? 'N/A')) !!},
            datasets: [{
                label: 'Reportes',
                data: {!! json_encode($porArea->pluck('total')) !!},
                backgroundColor: '#3B7FA8',
                borderRadius: 6
            }]
        },
        options: { indexAxis: 'y', responsive: true, plugins: { legend: { display: false } }, scales: { x: { beginAtZero: true, ticks: { stepSize: 1 } } } }
    });

    // Tendencia
    new Chart(document.getElementById('chartTendencia'), {
        type: 'line',
        data: {
            labels: {!! json_encode($tendencia->pluck('mes')) !!},
            datasets: [{
                label: 'Reportes por mes',
                data: {!! json_encode($tendencia->pluck('total')) !!},
                borderColor: '#ED6B37',
                backgroundColor: 'rgba(237,107,55,0.1)',
                fill: true,
                tension: 0.3,
                pointRadius: 4,
                pointBackgroundColor: '#ED6B37'
            }]
        },
        options: { responsive: true, scales: { y: { beginAtZero: true, ticks: { stepSize: 1 } } } }
    });
</script>
@endsection
