@extends('layouts.guest')

@section('content')
<div class="min-h-[70vh] flex items-center justify-center py-8">
    <div class="w-full max-w-md">

        {{-- Login card --}}
        <div class="bg-white rounded-xl shadow-lg border border-gray-200 overflow-hidden">

            {{-- Card header --}}
            <div class="px-6 py-8 text-center" style="background-color: #185E83;">
                <div class="w-14 h-14 rounded-xl flex items-center justify-center mx-auto mb-3" style="background-color: rgba(255,255,255,0.2);">
                    <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                              d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                    </svg>
                </div>
                <h2 class="text-xl font-bold text-white">Iniciar Sesion</h2>
                <p class="text-sm mt-1" style="color: #A8D4F0;">Accede al panel de administracion</p>
            </div>

            {{-- Form --}}
            <div class="px-6 py-6">

                {{-- Validation errors --}}
                @if($errors->any())
                    <div class="mb-4 p-3 bg-red-50 border border-red-200 rounded-lg">
                        <div class="flex items-start">
                            <svg class="w-5 h-5 text-red-500 mr-2 mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                      d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            <div>
                                <p class="text-sm font-medium text-red-800">Se encontraron errores:</p>
                                <ul class="mt-1 text-sm text-red-600 list-disc list-inside">
                                    @foreach($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                    </div>
                @endif

                <form method="POST" action="{{ route('login') }}" class="space-y-5">
                    @csrf

                    {{-- Usuario --}}
                    <div>
                        <label for="username" class="block text-sm font-medium text-gray-700 mb-1">
                            Usuario
                        </label>
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                          d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                                </svg>
                            </div>
                            <input id="username"
                                   name="username"
                                   type="text"
                                   value="{{ old('username') }}"
                                   required
                                   autofocus
                                   autocomplete="username"
                                   placeholder="Tu nombre de usuario"
                                   class="block w-full pl-10 pr-3 py-2.5 border border-gray-300 rounded-lg shadow-sm
                                          placeholder-gray-400 text-gray-900 text-sm
                                          focus:outline-none focus:ring-2 focus:border-transparent
                                          @error('username') border-red-300 ring-red-100 @enderror"
                                   style="--tw-ring-color: #3B7FA8;"
                                   onfocus="this.style.boxShadow='0 0 0 2px #3B7FA8'; this.style.borderColor='#3B7FA8';"
                                   onblur="this.style.boxShadow='none'; this.style.borderColor='#d1d5db';">
                        </div>
                    </div>

                    {{-- Password --}}
                    <div>
                        <label for="password" class="block text-sm font-medium text-gray-700 mb-1">
                            Contrasena
                        </label>
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                          d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/>
                                </svg>
                            </div>
                            <input id="password"
                                   name="password"
                                   type="password"
                                   required
                                   autocomplete="current-password"
                                   placeholder="Tu contrasena"
                                   class="block w-full pl-10 pr-3 py-2.5 border border-gray-300 rounded-lg shadow-sm
                                          placeholder-gray-400 text-gray-900 text-sm
                                          focus:outline-none focus:ring-2 focus:border-transparent
                                          @error('password') border-red-300 ring-red-100 @enderror"
                                   style="--tw-ring-color: #3B7FA8;"
                                   onfocus="this.style.boxShadow='0 0 0 2px #3B7FA8'; this.style.borderColor='#3B7FA8';"
                                   onblur="this.style.boxShadow='none'; this.style.borderColor='#d1d5db';">
                        </div>
                    </div>

                    {{-- Remember me --}}
                    <div class="flex items-center">
                        <input id="remember"
                               name="remember"
                               type="checkbox"
                               {{ old('remember') ? 'checked' : '' }}
                               class="h-4 w-4 border-gray-300 rounded"
                               style="accent-color: #ED6B37;">
                        <label for="remember" class="ml-2 block text-sm text-gray-600">
                            Recordar sesion
                        </label>
                    </div>

                    {{-- Submit --}}
                    <button type="submit"
                            class="w-full flex justify-center py-2.5 px-4 border border-transparent rounded-lg shadow-sm
                                   text-sm font-semibold text-white
                                   focus:outline-none focus:ring-2 focus:ring-offset-2
                                   transition-colors duration-200"
                            style="background-color: #ED6B37;"
                            onmouseover="this.style.backgroundColor='#D45A2A';"
                            onmouseout="this.style.backgroundColor='#ED6B37';">
                        Iniciar Sesion
                    </button>
                </form>
            </div>
        </div>

        {{-- Link to public report form --}}
        <div class="mt-6 text-center">
            <a href="{{ route('reporte.create') }}"
               class="text-sm font-medium transition-colors"
               style="color: #3B7FA8;"
               onmouseover="this.style.color='#185E83';"
               onmouseout="this.style.color='#3B7FA8';">
                <svg class="w-4 h-4 inline-block mr-1 -mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/>
                </svg>
                Volver al formulario de reportes
            </a>
        </div>

    </div>
</div>
@endsection
