@extends('layouts.admin')

@section('page-title', 'Gestión de Usuarios')

@section('content')
<div class="space-y-6">
    <div class="flex items-center justify-between">
        <h2 class="text-xl font-bold text-gray-800">Usuarios</h2>
        <a href="{{ route('admin.usuarios.create') }}"
           class="text-white px-4 py-2 rounded-lg text-sm font-medium transition flex items-center space-x-1"
           style="background-color: #ED6B37;"
           onmouseover="this.style.backgroundColor='#D4572B'"
           onmouseout="this.style.backgroundColor='#ED6B37'"
            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/>
            </svg>
            <span>Nuevo Usuario</span>
        </a>
    </div>

    <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
        <div class="overflow-x-auto">
            <table class="w-full text-sm">
                <thead class="bg-gray-50 text-gray-600">
                    <tr>
                        <th class="px-4 py-3 text-left font-medium">Nombre</th>
                        <th class="px-4 py-3 text-left font-medium">Usuario</th>
                        <th class="px-4 py-3 text-left font-medium">Email</th>
                        <th class="px-4 py-3 text-left font-medium">Rol</th>
                        <th class="px-4 py-3 text-left font-medium">Estado</th>
                        <th class="px-4 py-3 text-left font-medium">Acciones</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    @forelse($usuarios as $usuario)
                    <tr class="hover:bg-gray-50">
                        <td class="px-4 py-3 font-medium text-gray-800">{{ $usuario->nombre_completo }}</td>
                        <td class="px-4 py-3 text-gray-600 font-mono text-xs">{{ $usuario->username }}</td>
                        <td class="px-4 py-3 text-gray-500">{{ $usuario->email ?? '—' }}</td>
                        <td class="px-4 py-3">
                            <span class="px-2 py-1 rounded-full text-xs font-medium
                                {{ $usuario->rol === 'admin' ? 'bg-purple-100 text-purple-700' :
                                   ($usuario->rol === 'supervisor' ? 'bg-blue-100 text-blue-700' : 'bg-gray-100 text-gray-700') }}">
                                {{ ucfirst($usuario->rol) }}
                            </span>
                        </td>
                        <td class="px-4 py-3">
                            <span class="px-2 py-1 rounded-full text-xs font-medium {{ $usuario->activo ? 'bg-green-100 text-green-700' : 'bg-red-100 text-red-700' }}">
                                {{ $usuario->activo ? 'Activo' : 'Inactivo' }}
                            </span>
                        </td>
                        <td class="px-4 py-3 space-x-2">
                            <a href="{{ route('admin.usuarios.edit', $usuario) }}" class="text-xs font-medium" style="color: #3B7FA8;" onmouseover="this.style.color='#185E83'" onmouseout="this.style.color='#3B7FA8'">Editar</a>
                            @if($usuario->id !== auth()->id())
                            <form action="{{ route('admin.usuarios.destroy', $usuario) }}" method="POST" class="inline"
                                  onsubmit="return confirm('¿Desactivar este usuario?')">
                                @csrf @method('DELETE')
                                <button type="submit" class="text-red-500 hover:text-red-700 text-xs font-medium">Desactivar</button>
                            </form>
                            @endif
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="px-4 py-8 text-center text-gray-400">No hay usuarios.</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="px-4 py-3 border-t border-gray-100">
            {{ $usuarios->links() }}
        </div>
    </div>
</div>
@endsection
