@extends('layouts.admin')

@section('page-title', 'Editar Usuario')

@section('content')
<div class="max-w-2xl mx-auto">
    <div class="flex items-center justify-between mb-6">
        <h2 class="text-xl font-bold text-gray-800">Editar: {{ $usuario->nombre_completo }}</h2>
        <a href="{{ route('admin.usuarios.index') }}" class="text-sm hover:underline" style="color: #3B7FA8;">&larr; Volver</a>
    </div>

    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
        @if($errors->any())
        <div class="mb-4 p-3 bg-red-50 border border-red-200 rounded-lg">
            <ul class="text-sm text-red-600 list-disc list-inside">
                @foreach($errors->all() as $error)
                <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
        @endif

        <form action="{{ route('admin.usuarios.update', $usuario) }}" method="POST" enctype="multipart/form-data" class="space-y-5">
            @csrf @method('PUT')

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Nombre completo</label>
                <input type="text" name="nombre_completo" value="{{ old('nombre_completo', $usuario->nombre_completo) }}" required
                       class="w-full border border-gray-300 rounded-lg px-3 py-2.5 text-sm focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Nombre de usuario</label>
                <input type="text" name="username" value="{{ old('username', $usuario->username) }}" required
                       placeholder="ej: jperez"
                       class="w-full border border-gray-300 rounded-lg px-3 py-2.5 text-sm focus:ring-2 focus:border-transparent"
                       style="--tw-ring-color: #3B7FA8;"
                       onfocus="this.style.boxShadow='0 0 0 2px #3B7FA8'; this.style.borderColor='#3B7FA8';"
                       onblur="this.style.boxShadow='none'; this.style.borderColor='#d1d5db';">
                <p class="text-xs text-gray-400 mt-1">Solo letras, números, puntos, guiones y guiones bajos.</p>
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Correo electrónico <span class="text-gray-400">(opcional)</span></label>
                <input type="email" name="email" value="{{ old('email', $usuario->email) }}"
                       class="w-full border border-gray-300 rounded-lg px-3 py-2.5 text-sm focus:ring-2 focus:border-transparent"
                       style="--tw-ring-color: #3B7FA8;"
                       onfocus="this.style.boxShadow='0 0 0 2px #3B7FA8'; this.style.borderColor='#3B7FA8';"
                       onblur="this.style.boxShadow='none'; this.style.borderColor='#d1d5db';">
            </div>

            <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Nueva contraseña <span class="text-gray-400">(dejar vacío para no cambiar)</span></label>
                    <input type="password" name="password"
                           class="w-full border border-gray-300 rounded-lg px-3 py-2.5 text-sm focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Confirmar contraseña</label>
                    <input type="password" name="password_confirmation"
                           class="w-full border border-gray-300 rounded-lg px-3 py-2.5 text-sm focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                </div>
            </div>

            <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Rol</label>
                    <select name="rol" required
                            class="w-full border border-gray-300 rounded-lg px-3 py-2.5 text-sm focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                        <option value="trabajador" {{ $usuario->rol === 'trabajador' ? 'selected' : '' }}>Trabajador</option>
                        <option value="supervisor" {{ $usuario->rol === 'supervisor' ? 'selected' : '' }}>Supervisor</option>
                        <option value="admin" {{ $usuario->rol === 'admin' ? 'selected' : '' }}>Admin</option>
                    </select>
                </div>
                <div class="flex items-center pt-6">
                    <label class="flex items-center space-x-2 cursor-pointer">
                        <input type="hidden" name="activo" value="0">
                        <input type="checkbox" name="activo" value="1" {{ $usuario->activo ? 'checked' : '' }}
                               class="h-4 w-4 focus:ring-blue-500 border-gray-300 rounded"
                               style="accent-color: #ED6B37;">
                        <span class="text-sm text-gray-700">Cuenta activa</span>
                    </label>
                </div>
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Firma PNG (supervisores)</label>
                @if($usuario->firma_png_path)
                <div class="mb-2 p-2 bg-gray-50 rounded-lg inline-block">
                    <img src="{{ Storage::url($usuario->firma_png_path) }}" alt="Firma actual" class="h-16">
                    <p class="text-xs text-gray-400 mt-1">Firma actual</p>
                </div>
                @endif
                <input type="file" name="firma_png" accept="image/png"
                       class="w-full border border-gray-300 rounded-lg px-3 py-2 text-sm file:mr-3 file:py-1 file:px-3 file:rounded file:border-0 file:text-sm file:font-medium file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100">
                <p class="text-xs text-gray-400 mt-1">Suba una nueva imagen PNG para reemplazar la firma actual.</p>
            </div>

            <div class="pt-3">
                <button type="submit"
                        class="w-full text-white py-2.5 px-4 rounded-lg text-sm font-semibold transition"
                        style="background-color: #ED6B37;"
                        onmouseover="this.style.backgroundColor='#D4572B'"
                        onmouseout="this.style.backgroundColor='#ED6B37'">
                    Actualizar Usuario
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
