@extends('layouts.admin')

@section('page-title', $config['titulo'])

@section('content')
<div class="space-y-6">
    <div class="flex items-center justify-between">
        <div>
            <h2 class="text-xl font-bold text-gray-800">{{ $config['titulo'] }}</h2>
            <a href="{{ route('admin.catalogos.index') }}" class="text-sm hover:underline" style="color: #3B7FA8;">&larr; Volver a catálogos</a>
        </div>
    </div>

    {{-- Formulario para agregar --}}
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-5">
        <h3 class="text-base font-semibold text-gray-700 mb-3">Agregar nuevo registro</h3>
        <form action="{{ route('admin.catalogos.store', $catalogo) }}" method="POST" class="flex flex-wrap items-end gap-3">
            @csrf
            <div class="flex-1 min-w-[200px]">
                <label class="block text-sm font-medium text-gray-600 mb-1">Nombre</label>
                <input type="text" name="nombre" required
                       class="w-full border border-gray-300 rounded-lg px-3 py-2 text-sm focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
            </div>
            <div class="w-24">
                <label class="block text-sm font-medium text-gray-600 mb-1">Orden</label>
                <input type="number" name="orden" value="0" min="0"
                       class="w-full border border-gray-300 rounded-lg px-3 py-2 text-sm focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
            </div>
            @if(in_array('horas', $config['extra_fields']))
            <div class="w-24">
                <label class="block text-sm font-medium text-gray-600 mb-1">Horas</label>
                <input type="number" name="horas" min="1" required
                       class="w-full border border-gray-300 rounded-lg px-3 py-2 text-sm focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
            </div>
            @endif
            <button type="submit"
                    class="text-white px-4 py-2 rounded-lg text-sm font-medium transition"
                    style="background-color: #ED6B37;"
                    onmouseover="this.style.backgroundColor='#D4572B'"
                    onmouseout="this.style.backgroundColor='#ED6B37'">
                Agregar
            </button>
        </form>
    </div>

    {{-- Tabla de items --}}
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
        <div class="overflow-x-auto">
            <table class="w-full text-sm">
                <thead class="bg-gray-50 text-gray-600">
                    <tr>
                        <th class="px-4 py-3 text-left font-medium">ID</th>
                        <th class="px-4 py-3 text-left font-medium">Nombre</th>
                        <th class="px-4 py-3 text-left font-medium">Orden</th>
                        @if(in_array('horas', $config['extra_fields']))
                        <th class="px-4 py-3 text-left font-medium">Horas</th>
                        @endif
                        <th class="px-4 py-3 text-left font-medium">Estado</th>
                        <th class="px-4 py-3 text-left font-medium">Acciones</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    @forelse($items as $item)
                    <tr x-data="{ editing: false }" class="hover:bg-gray-50">
                        <td class="px-4 py-3 text-gray-500">{{ $item->id }}</td>
                        <td class="px-4 py-3">
                            <span x-show="!editing" class="font-medium text-gray-800">{{ $item->nombre }}</span>
                            <form x-show="editing" x-cloak
                                  action="{{ route('admin.catalogos.update', [$catalogo, $item->id]) }}" method="POST"
                                  class="flex items-center gap-2">
                                @csrf @method('PUT')
                                <input type="text" name="nombre" value="{{ $item->nombre }}" required
                                       class="border border-gray-300 rounded px-2 py-1 text-sm flex-1">
                                <input type="number" name="orden" value="{{ $item->orden }}" min="0"
                                       class="border border-gray-300 rounded px-2 py-1 text-sm w-16">
                                @if(in_array('horas', $config['extra_fields']))
                                <input type="number" name="horas" value="{{ $item->horas ?? '' }}" min="1" required
                                       class="border border-gray-300 rounded px-2 py-1 text-sm w-16">
                                @endif
                                <button type="submit" class="text-green-600 hover:text-green-800 font-medium text-xs">Guardar</button>
                                <button type="button" @click="editing = false" class="text-gray-400 hover:text-gray-600 text-xs">Cancelar</button>
                            </form>
                        </td>
                        <td class="px-4 py-3 text-gray-500" x-show="!editing">{{ $item->orden }}</td>
                        @if(in_array('horas', $config['extra_fields']))
                        <td class="px-4 py-3 text-gray-500" x-show="!editing">{{ $item->horas ?? '-' }}</td>
                        @endif
                        <td class="px-4 py-3" x-show="!editing">
                            <form action="{{ route('admin.catalogos.toggle', [$catalogo, $item->id]) }}" method="POST" class="inline">
                                @csrf @method('PATCH')
                                <button type="submit" class="px-2 py-1 rounded-full text-xs font-medium {{ $item->activo ? 'bg-green-100 text-green-700 hover:bg-green-200' : 'bg-red-100 text-red-700 hover:bg-red-200' }} transition">
                                    {{ $item->activo ? 'Activo' : 'Inactivo' }}
                                </button>
                            </form>
                        </td>
                        <td class="px-4 py-3 space-x-2" x-show="!editing">
                            <button @click="editing = true" class="text-xs font-medium" style="color: #3B7FA8;" onmouseover="this.style.color='#185E83'" onmouseout="this.style.color='#3B7FA8'">Editar</button>
                            <form action="{{ route('admin.catalogos.destroy', [$catalogo, $item->id]) }}" method="POST" class="inline"
                                  onsubmit="return confirm('¿Eliminar este registro?')">
                                @csrf @method('DELETE')
                                <button type="submit" class="text-red-500 hover:text-red-700 text-xs font-medium">Eliminar</button>
                            </form>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="px-4 py-8 text-center text-gray-400">No hay registros aún.</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
<style>[x-cloak] { display: none !important; }</style>
@endsection
