@extends('layouts.admin')

@section('page-title', 'Gestión de Catálogos')

@section('content')
<div class="space-y-6">
    <div class="flex items-center justify-between">
        <h2 class="text-xl font-bold text-gray-800">Catálogos del Sistema</h2>
    </div>

    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-4">
        @foreach($catalogos as $key => $config)
        <a href="{{ route('admin.catalogos.manage', $key) }}"
           class="bg-white rounded-xl shadow-sm border border-gray-200 p-5 hover:shadow-md hover:border-blue-300 transition group">
            <div class="flex items-center space-x-3">
                <div class="w-10 h-10 rounded-lg flex items-center justify-center transition" style="background-color: rgba(59,127,168,0.15);" onmouseover="this.style.backgroundColor='rgba(59,127,168,0.25)'" onmouseout="this.style.backgroundColor='rgba(59,127,168,0.15)'">
                    <svg class="w-5 h-5" style="color: #3B7FA8;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 10h16M4 14h16M4 18h16"/>
                    </svg>
                </div>
                <div>
                    <h3 class="font-semibold text-gray-800 transition" style="group-hover-color: #3B7FA8;">{{ $config['titulo'] }}</h3>
                    <p class="text-xs text-gray-400">Gestionar opciones</p>
                </div>
            </div>
        </a>
        @endforeach
    </div>
</div>
@endsection
