<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class TurnoSeeder extends Seeder
{
    public function run(): void
    {
        $turnos = [
            ['nombre' => 'Día', 'orden' => 1],
            ['nombre' => 'Noche', 'orden' => 2],
        ];

        foreach ($turnos as $turno) {
            DB::table('turnos')->insert(array_merge($turno, [
                'activo' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ]));
        }
    }
}
