<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class TipoReporteSeeder extends Seeder
{
    public function run(): void
    {
        $tipos = [
            ['nombre' => 'Condición subestándar', 'orden' => 1],
            ['nombre' => 'Acto subestándar', 'orden' => 2],
            ['nombre' => 'Incidente ambiental', 'orden' => 3],
            ['nombre' => 'Incidente', 'orden' => 4],
            ['nombre' => 'Daño de propiedad', 'orden' => 5],
            ['nombre' => 'Número de tipo de causa', 'orden' => 6],
        ];

        foreach ($tipos as $tipo) {
            DB::table('tipos_reporte')->insert(array_merge($tipo, [
                'activo' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ]));
        }
    }
}
