<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class PlazoHorasSeeder extends Seeder
{
    public function run(): void
    {
        $plazos = [
            ['nombre' => '4 horas', 'horas' => 4, 'orden' => 1],
            ['nombre' => '8 horas', 'horas' => 8, 'orden' => 2],
            ['nombre' => '12 horas', 'horas' => 12, 'orden' => 3],
            ['nombre' => '24 horas', 'horas' => 24, 'orden' => 4],
            ['nombre' => '48 horas', 'horas' => 48, 'orden' => 5],
            ['nombre' => '72 horas', 'horas' => 72, 'orden' => 6],
        ];

        foreach ($plazos as $plazo) {
            DB::table('plazos_horas')->insert(array_merge($plazo, [
                'activo' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ]));
        }
    }
}
