<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class NivelRiesgoSeeder extends Seeder
{
    public function run(): void
    {
        $niveles = [
            ['nombre' => 'Alto', 'orden' => 1],
            ['nombre' => 'Medio', 'orden' => 2],
            ['nombre' => 'Bajo', 'orden' => 3],
        ];

        foreach ($niveles as $nivel) {
            DB::table('niveles_riesgo')->insert(array_merge($nivel, [
                'activo' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ]));
        }
    }
}
