<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class NivelConsecuenciaSeeder extends Seeder
{
    public function run(): void
    {
        $niveles = [
            ['nombre' => 'Sin impacto', 'orden' => 1],
            ['nombre' => 'Bajo', 'orden' => 2],
            ['nombre' => 'Moderado', 'orden' => 3],
            ['nombre' => 'Mayor', 'orden' => 4],
            ['nombre' => 'Catastrófico', 'orden' => 5],
        ];

        foreach ($niveles as $nivel) {
            DB::table('niveles_consecuencia')->insert(array_merge($nivel, [
                'activo' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ]));
        }
    }
}
