<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class LugarSeeder extends Seeder
{
    public function run(): void
    {
        $lugares = [
            ['nombre' => 'Campamento de trabajadores', 'orden' => 1],
            ['nombre' => 'Área de Proveo', 'orden' => 2],
            ['nombre' => 'Almacén general', 'orden' => 3],
            ['nombre' => 'Taller de mantenimiento', 'orden' => 4],
            ['nombre' => 'Oficinas administrativas', 'orden' => 5],
        ];

        foreach ($lugares as $lugar) {
            DB::table('lugares')->insert(array_merge($lugar, [
                'activo' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ]));
        }
    }
}
