<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class EstadoReporteSeeder extends Seeder
{
    public function run(): void
    {
        $estados = [
            ['nombre' => 'Nuevo', 'orden' => 1],
            ['nombre' => 'En revisión', 'orden' => 2],
            ['nombre' => 'Acción definida', 'orden' => 3],
            ['nombre' => 'Cerrado', 'orden' => 4],
        ];

        foreach ($estados as $estado) {
            DB::table('estados_reporte')->insert(array_merge($estado, [
                'activo' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ]));
        }
    }
}
