<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class AreaSeeder extends Seeder
{
    public function run(): void
    {
        $areas = [
            ['nombre' => 'Cancha 1', 'orden' => 1],
            ['nombre' => 'Cancha 2', 'orden' => 2],
            ['nombre' => 'Cancha 3', 'orden' => 3],
            ['nombre' => 'Cancha 4', 'orden' => 4],
            ['nombre' => 'Cancha 5', 'orden' => 5],
            ['nombre' => 'Cancha 6', 'orden' => 6],
            ['nombre' => 'Cancha 7', 'orden' => 7],
            ['nombre' => 'Cancha 8', 'orden' => 8],
            ['nombre' => 'Planta', 'orden' => 9],
            ['nombre' => 'Chala', 'orden' => 10],
        ];

        foreach ($areas as $area) {
            DB::table('areas')->insert(array_merge($area, [
                'activo' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ]));
        }
    }
}
