<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // 1. Agregar columna sin unique constraint
        Schema::table('users', function (Blueprint $table) {
            $table->string('username')->nullable()->after('nombre_completo');
        });

        // 2. Generar username a partir del email existente para usuarios actuales
        DB::table('users')->get()->each(function ($user) {
            $username = explode('@', $user->email)[0];
            DB::table('users')->where('id', $user->id)->update(['username' => $username]);
        });

        // 3. Ahora agregar el unique index y hacer NOT NULL
        DB::statement('ALTER TABLE users MODIFY username VARCHAR(255) NOT NULL');
        Schema::table('users', function (Blueprint $table) {
            $table->unique('username');
        });

        // 4. Hacer email nullable (ya no es campo de login)
        DB::statement('ALTER TABLE users MODIFY email VARCHAR(255) NULL');
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Restaurar email como NOT NULL
        DB::statement('ALTER TABLE users MODIFY email VARCHAR(255) NOT NULL');

        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn('username');
        });
    }
};
