<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('reportes', function (Blueprint $table) {
            $table->id();
            $table->string('codigo')->unique();
            $table->foreignId('tipo_id')->constrained('tipos_reporte');
            $table->foreignId('lugar_id')->constrained('lugares');
            $table->foreignId('area_id')->constrained('areas');
            $table->foreignId('turno_id')->constrained('turnos');
            $table->text('descripcion');
            $table->foreignId('riesgo_id')->constrained('niveles_riesgo');
            $table->foreignId('consecuencia_id')->nullable()->constrained('niveles_consecuencia');
            $table->boolean('es_anonimo')->default(false);
            $table->foreignId('reportado_por_user_id')->nullable()->constrained('users');
            $table->string('reportado_por_texto')->nullable();
            $table->string('firma_trabajador_path')->nullable();

            // Parte B
            $table->text('accion_correctiva')->nullable();
            $table->foreignId('supervisor_id')->nullable()->constrained('users');
            $table->string('firma_supervisor_path')->nullable();
            $table->foreignId('plazo_horas_id')->nullable()->constrained('plazos_horas');
            $table->timestamp('fecha_limite')->nullable();
            $table->foreignId('estado_id')->constrained('estados_reporte');

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('reportes');
    }
};
