<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    use HasFactory, Notifiable;

    protected $fillable = [
        'nombre_completo',
        'username',
        'email',
        'password',
        'rol',
        'activo',
        'firma_png_path',
    ];

    protected $hidden = [
        'password',
        'remember_token',
    ];

    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
            'activo' => 'boolean',
        ];
    }

    public function esAdmin(): bool
    {
        return $this->rol === 'admin';
    }

    public function esSupervisor(): bool
    {
        return $this->rol === 'supervisor';
    }

    public function scopeActivos($query)
    {
        return $query->where('activo', true);
    }

    public function scopeSupervisores($query)
    {
        return $query->where('rol', 'supervisor')->where('activo', true);
    }
}
