<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreReporteRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'tipo_id' => 'required|exists:tipos_reporte,id',
            'lugar_id' => 'required|exists:lugares,id',
            'area_id' => 'required|exists:areas,id',
            'turno_id' => 'required|exists:turnos,id',
            'descripcion' => 'required|string|max:500',
            'riesgo_id' => 'required|exists:niveles_riesgo,id',
            'consecuencia_id' => 'nullable|exists:niveles_consecuencia,id',
            'es_anonimo' => 'boolean',
            'reportado_por_user_id' => 'nullable|exists:users,id',
            'reportado_por_texto' => 'nullable|string|max:255',
            'fotos' => 'nullable|array|max:3',
            'fotos.*' => 'image|mimes:jpg,jpeg,png,webp|max:5120',
            'firma_trabajador' => 'required|string',
        ];
    }

    public function withValidator($validator)
    {
        $validator->after(function ($validator) {
            if (!$this->boolean('es_anonimo') && !$this->reportado_por_user_id && !$this->reportado_por_texto) {
                $validator->errors()->add('reportado_por_texto', 'Debe indicar quién reporta o marcar como anónimo.');
            }
            if ($this->boolean('es_anonimo') && (!$this->hasFile('fotos') || count($this->file('fotos')) < 1)) {
                $validator->errors()->add('fotos', 'Los reportes anónimos requieren al menos una foto.');
            }
        });
    }

    public function messages(): array
    {
        return [
            'tipo_id.required' => 'Seleccione el tipo de reporte.',
            'lugar_id.required' => 'Seleccione el lugar.',
            'area_id.required' => 'Seleccione el área.',
            'turno_id.required' => 'Seleccione el turno.',
            'descripcion.required' => 'Ingrese la descripción del incidente.',
            'descripcion.max' => 'La descripción no puede superar los 500 caracteres.',
            'riesgo_id.required' => 'Seleccione el nivel de riesgo.',
            'fotos.max' => 'Máximo 3 fotos permitidas.',
            'fotos.*.max' => 'Cada foto no debe superar 5MB.',
            'fotos.*.mimes' => 'Solo se permiten imágenes JPG, PNG o WebP.',
            'firma_trabajador.required' => 'La firma es obligatoria.',
        ];
    }
}
