<?php

namespace App\Http\Controllers;

use App\Models\Reporte;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Http\Request;

class ReportePdfController extends Controller
{
    public function show(Reporte $reporte)
    {
        $reporte->load(['tipo', 'lugar', 'area', 'turno', 'riesgo', 'consecuencia', 'fotos', 'reportadoPor', 'supervisor', 'plazo', 'estado']);

        $pdf = Pdf::loadView('reportes.pdf.individual', compact('reporte'));
        $pdf->setPaper('A4', 'portrait');

        return $pdf->stream('reporte-' . $reporte->codigo . '.pdf');
    }

    public function masivo(Request $request)
    {
        $reportes = Reporte::with(['tipo', 'lugar', 'area', 'turno', 'riesgo', 'consecuencia', 'fotos', 'reportadoPor', 'supervisor', 'plazo', 'estado'])
            ->filter($request->all())
            ->orderByDesc('created_at')
            ->get();

        $pdf = Pdf::loadView('reportes.pdf.masivo', compact('reportes'));
        $pdf->setPaper('A4', 'portrait');

        return $pdf->download('reportes-' . now()->format('Y-m') . '.pdf');
    }
}
