<?php

namespace App\Http\Controllers;

use App\Models\Area;
use App\Models\EstadoReporte;
use App\Models\Lugar;
use App\Models\NivelRiesgo;
use App\Models\Reporte;
use App\Models\TipoReporte;
use App\Models\Turno;
use App\Models\User;
use Illuminate\Http\Request;

class ReporteListController extends Controller
{
    public function index(Request $request)
    {
        $reportes = Reporte::with(['tipo', 'lugar', 'area', 'riesgo', 'estado', 'supervisor'])
            ->filter($request->all())
            ->orderByDesc('created_at')
            ->paginate(15)
            ->withQueryString();

        return view('reportes.index', [
            'reportes' => $reportes,
            'tipos' => TipoReporte::activos()->get(),
            'lugares' => Lugar::activos()->get(),
            'areas' => Area::activos()->get(),
            'turnos' => Turno::activos()->get(),
            'riesgos' => NivelRiesgo::activos()->get(),
            'estados' => EstadoReporte::activos()->get(),
            'supervisores' => User::supervisores()->get(),
            'filters' => $request->all(),
        ]);
    }

    public function show(Reporte $reporte)
    {
        $reporte->load(['tipo', 'lugar', 'area', 'turno', 'riesgo', 'consecuencia', 'fotos', 'reportadoPor', 'supervisor', 'plazo', 'estado']);

        return view('reportes.show', compact('reporte'));
    }
}
