<?php

namespace App\Http\Controllers;

use App\Models\EstadoReporte;
use App\Models\PlazoHoras;
use App\Models\Reporte;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class ParteBController extends Controller
{
    public function edit(Reporte $reporte)
    {
        return view('reportes.parte-b', [
            'reporte' => $reporte->load(['tipo', 'lugar', 'area', 'turno', 'riesgo', 'consecuencia', 'fotos', 'estado']),
            'supervisores' => User::supervisores()->orderBy('nombre_completo')->get(),
            'plazos' => PlazoHoras::activos()->get(),
            'estados' => EstadoReporte::activos()->get(),
        ]);
    }

    public function update(Request $request, Reporte $reporte)
    {
        $validated = $request->validate([
            'accion_correctiva' => 'required|string|max:2000',
            'supervisor_id' => 'required|exists:users,id',
            'plazo_horas_id' => 'required|exists:plazos_horas,id',
            'estado_id' => 'required|exists:estados_reporte,id',
            'firma_supervisor_live' => 'nullable|string',
        ]);

        $plazo = PlazoHoras::find($validated['plazo_horas_id']);
        $validated['fecha_limite'] = now()->addHours($plazo->horas);

        // Firma del supervisor
        if ($request->firma_supervisor_live) {
            $imageData = base64_decode(preg_replace('#^data:image/\w+;base64,#i', '', $request->firma_supervisor_live));
            $path = 'firmas/supervisor_reporte_' . $reporte->id . '.png';
            Storage::disk('public')->put($path, $imageData);
            $validated['firma_supervisor_path'] = $path;
        } else {
            $supervisor = User::find($validated['supervisor_id']);
            if ($supervisor && $supervisor->firma_png_path) {
                $validated['firma_supervisor_path'] = $supervisor->firma_png_path;
            }
        }

        unset($validated['firma_supervisor_live']);
        $reporte->update($validated);

        return redirect()->route('reportes.show', $reporte)->with('success', 'Parte B actualizada correctamente.');
    }
}
