<?php

namespace App\Http\Controllers;

use App\Models\Area;
use App\Models\EstadoReporte;
use App\Models\Lugar;
use App\Models\NivelRiesgo;
use App\Models\Reporte;
use App\Models\TipoReporte;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class DashboardController extends Controller
{
    public function index(Request $request)
    {
        $filters = $request->all();

        $totalReportes = Reporte::filter($filters)->count();
        $reportesMes = Reporte::whereMonth('created_at', now()->month)
            ->whereYear('created_at', now()->year)
            ->count();

        $porTipo = Reporte::filter($filters)
            ->select('tipo_id', DB::raw('COUNT(*) as total'))
            ->groupBy('tipo_id')
            ->with('tipo')
            ->get();

        $porArea = Reporte::filter($filters)
            ->select('area_id', DB::raw('COUNT(*) as total'))
            ->groupBy('area_id')
            ->with('area')
            ->get();

        $porRiesgo = Reporte::filter($filters)
            ->select('riesgo_id', DB::raw('COUNT(*) as total'))
            ->groupBy('riesgo_id')
            ->with('riesgo')
            ->get();

        $estadoCerrado = EstadoReporte::where('nombre', 'Cerrado')->first();

        $vencidos = Reporte::filter($filters)
            ->whereNotNull('fecha_limite')
            ->where('fecha_limite', '<', now())
            ->where('estado_id', '!=', $estadoCerrado?->id ?? 0)
            ->count();

        $aTiempo = Reporte::filter($filters)
            ->whereNotNull('fecha_limite')
            ->where(function ($q) use ($estadoCerrado) {
                $q->where('fecha_limite', '>=', now())
                  ->orWhere('estado_id', $estadoCerrado?->id ?? 0);
            })
            ->count();

        $tendencia = Reporte::select(
                DB::raw("DATE_FORMAT(created_at, '%Y-%m') as mes"),
                DB::raw('COUNT(*) as total')
            )
            ->where('created_at', '>=', now()->subMonths(12))
            ->groupBy('mes')
            ->orderBy('mes')
            ->get();

        return view('dashboard.index', compact(
            'totalReportes', 'reportesMes', 'porTipo', 'porArea',
            'porRiesgo', 'vencidos', 'aTiempo', 'tendencia', 'filters'
        ));
    }
}
