<?php

namespace App\Helpers;

use Illuminate\Support\Facades\Storage;

class PdfHelper
{
    public static function imageToBase64(?string $storagePath): string
    {
        if (!$storagePath) {
            return '';
        }

        $fullPath = Storage::disk('public')->path($storagePath);

        if (!file_exists($fullPath)) {
            return '';
        }

        $type = pathinfo($fullPath, PATHINFO_EXTENSION);
        $data = file_get_contents($fullPath);

        return 'data:image/' . $type . ';base64,' . base64_encode($data);
    }
}
