<?php

namespace App\Exports;

use App\Models\Reporte;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class ReportesExport implements FromQuery, WithHeadings, WithMapping, ShouldAutoSize
{
    protected array $filters;

    public function __construct(array $filters)
    {
        $this->filters = $filters;
    }

    public function query()
    {
        return Reporte::query()
            ->with(['tipo', 'lugar', 'area', 'turno', 'riesgo', 'consecuencia', 'supervisor', 'estado'])
            ->filter($this->filters)
            ->orderByDesc('created_at');
    }

    public function headings(): array
    {
        return [
            'Código', 'Fecha', 'Tipo', 'Lugar', 'Área', 'Turno',
            'Reportado Por', 'Descripción', 'Riesgo', 'Consecuencia',
            'Acción Correctiva', 'Supervisor', 'Plazo (h)', 'Fecha Límite',
            'Estado',
        ];
    }

    public function map($reporte): array
    {
        return [
            $reporte->codigo,
            $reporte->created_at->format('d/m/Y H:i'),
            $reporte->tipo->nombre ?? '',
            $reporte->lugar->nombre ?? '',
            $reporte->area->nombre ?? '',
            $reporte->turno->nombre ?? '',
            $reporte->nombre_reportante,
            $reporte->descripcion,
            $reporte->riesgo->nombre ?? '',
            $reporte->consecuencia->nombre ?? 'N/A',
            $reporte->accion_correctiva ?? '',
            $reporte->supervisor->nombre_completo ?? '',
            $reporte->plazo->horas ?? '',
            $reporte->fecha_limite?->format('d/m/Y H:i') ?? '',
            $reporte->estado->nombre ?? '',
        ];
    }
}
